var graph = {inheritance:[], files:{}, types:{}}
var inheritance_lookup = {}
var file_count = 0
var type_count = 0

function shorten_id(id) {
  var data = id.replace("/home/tglek/work/actionmonkey/", "").split(":")
  var file = data[0]
  var line = data[1] * 1
  var ret = graph.files[file]
  if (typeof ret != "undefined")
    return [ret, line]
  ret = file_count++;
  graph.files[file] = ret;
  return [ret, line]
}

function shorten_type(t) {
  var ret = graph.types[t]
  if (typeof ret != "undefined") return ret
  ret = type_count++
  graph.types[t] = ret
  return ret
}

function input_end() {
  print(uneval(graph))
}

function process_class(c) {
  // Ignore system headers
  if (c.loc.indexOf("/usr/") == 0 || !c.name) return
  var obj = new Object()
  obj.name = c.name
  obj.loc = shorten_id(c.loc)
  if(c.bases.length) {
    obj.bases = c.bases.map(function(name) { return inheritance_lookup[name]; }).filter(function(x) {return x})
    if (!obj.bases.length)
      delete obj.bases
  }
  obj.members = c.members.filter(function(x) {return x.name}).map(function (x) {
    var v = [x.name, shorten_type(x.type), shorten_id(x.loc)]
    if (x.parameters)
      v.push(x.parameters.map(function (p) {return [p.name, shorten_type(p.type)]}))
    if (x.isVirtual == "pure")
      v.push(2)
    else if (x.isVirtual)
      v.push(1)
    return v})
  if (!obj.members.length)
    delete obj.members
  inheritance_lookup[c.name] = graph.inheritance.length
  graph.inheritance.push(obj)
}
