eval(read_file("dehydra_scripts/inheritance.js"))

this.input_end = undefined
var types = []
var files = []

function reverse_cache(orig, cache) {
  for (var t in orig) {
    cache[orig[t]] = t
  }
}

function isPointer(type) {
  var c = type[type.length - 1]
  return c == '*' || c == "&"
}

function getClass(type) {
  var m = /^class (\w+)/(type)
  if (m) return m[1]
}

function ensureValidStack(class_name, guard) {
  if (!guard)
    guard = {}
  else if (guard[class_name])
    return
  guard[class_name] = true

  klass = inheritance_lookup[class_name]
  if (!klass) {
    print("Can't find " + class_name + " in class hierarchy")
    return
  }
  klass = graph.inheritance[klass]
  for each (var m in klass.members) {
    var type = types[m[1]]
    if (!type) {
      reverse_cache(graph.types, types)
      reverse_cache(graph.files, files)
      type = types[m[1]]
      if (!type)
        throw "Can't find type for " + class_name + "." + name
    }

    if (isPointer(type)) continue

    var klass = getClass(type)
    if (klass) {
      ensureValidStack(klass, guard)
      continue
    }
    
    var match = /^nsCOMPtr<.+>$/(type)
    // check for stack nscomptrs
    if (!match) continue;
    print(files[m[2][0]] + ":"+m[2][1] 
          + " \"" + type + " " + m[0] + "\" in "+class_name+" is not valid on the stack")
  }
}

function process(vars) {
  for each (var x in vars) {
    if (!x.isDecl || isPointer(x.type)) continue
    var m = getClass(x.type)
    if (!m) continue
    ensureValidStack(m)
  }
}


