// see License.txt for copyright and terms of use

// Detects code that shouldn't be rewritten

#ifndef GARBURATOR_BLACKLISTER_H
#define GARBURATOR_BLACKLISTER_H

#include "oink.h"
#include "cc_ast_aux.h"         // LoweredASTVisitor
#include <set>
#include <map>

class Blacklister : public ASTVisitor {
public:
  Blacklister():
    str_GetCallback(globalStrTable("GetCallback")),
    str_nsCOMPtr(globalStrTable("nsCOMPtr")),
    str_address_of(globalStrTable("address_of")),
    str_getter_AddRefs(globalStrTable("getter_AddRefs")),
    str_swap(globalStrTable("swap"))
  {}

  bool allowedToRewrite(Variable *v);
  
  virtual void postvisitExpression(Expression *e);
  virtual bool visitMember(Member *m);
  virtual void postvisitDeclarator(Declarator *d);
private:
  void blacklistVar(Variable *v);
  void blacklistTemplParams(E_funCall *e);
  void visitConstructorDecl(D_func *df);
  std::set<Variable*> blacklist;
  typedef std::map<Variable*, int> var_int_map;
  var_int_map damningFcalls;
  // these are variable::loc fields
  std::set<SourceLoc> templateParamLocSet;
  const StringRef str_GetCallback;
public:
  const StringRef str_nsCOMPtr;
  const StringRef str_address_of;
  const StringRef str_getter_AddRefs;
  const StringRef str_swap;
};

#endif // GARBURATOR_BLACKLISTER_H
