// see License.txt for copyright and terms of use

#include "garburator_cmd.h"    // this module
#include "oink_cmd_util.h"      // HANDLE_FLAG
#include "oink_util.h"
#include <cstring>              // strdup
#include <cstdlib>              // atoi

GarburatorCmd::GarburatorCmd()
  : debug (false)
{}

void GarburatorCmd::readOneArg(int &argc, char **&argv) {
  int old_argc = argc;
  OinkCmd::readOneArg(argc, argv);
  if (old_argc != argc) return; // the superclass read one so we don't

  char *arg = argv[0];
  // please prefix the names of flags with arguments with '-d-'
  if (streq(arg, "-pr-debug")) {
    shift(argc, argv);
    debug = true;
    return;
  }
}

void GarburatorCmd::dump() {
  OinkCmd::dump();
  // garburator arguments
  //
  // the idea here is to make the internal name be the same as the
  // external name with the dashes replaced by underscores
  printf("pr-debug: %s\n", boolToStr(debug));
}

void GarburatorCmd::printHelp() {
  OinkCmd::printHelp();
  printf
    ("garburator flags:\n"
     "  -pr-debug  Print info useful for debugging\n"
     "");
}

// push the state out to other places where it is needed; return value
// is true unless there is an error
void GarburatorCmd::initializeFromFlags() {
  OinkCmd::initializeFromFlags();
}
