// see License.txt for copyright and terms of use

// Just the main() function.

#include "garburator.h"
#include "garburator_cmd.h"
#include "garburator_global.h"
#include "oink.gr.gen.h"        // CCParse_Oink
#include "trace.h"
#include "oink_util.h"

using namespace std;

int main(int argc, char **argv) {
  traceAddSys("permissive");
  traceAddFromEnvVar();
  tFac = new TypeFactory_O;
  vFac = new ValueFactory;
  astPrinter = new ASTPrinter_O;
  oinkCmd = garburatorCmd = new GarburatorCmd;
  ExitCode code = NORMAL_ExitCode;
  GarburatorProcessor m;
  m.typePrinter = &typePrinterOink;
  try {
    m.init_stage(argc, argv);
    CCParse_Oink ccParse(globalStrTable, globalLang);
    m.parseUserActions = &ccParse;
    m.parseEnv = &ccParse;
    m.parse_stage();
    m.typecheck_stage();
    m.elaborate_stage();
    m.process(*garburatorCmd);
  } catch (xBase &e) {
    cerr << e << endl;
    code = INTERNALERROR_ExitCode;
    if (UserError *ue = dynamic_cast<UserError*>(&e)) code = ue->exitCode;
  }
  delete garburatorCmd;
  return code;
}
