// see License.txt for copyright and terms of use

// Just the main() function.

#include "nuker_cmd.h"
#include "oink.gr.gen.h"        // CCParse_Oink
#include "trace.h"
#include "oink_util.h"
#include "oink_global.h"

using namespace std;

NukerCmd::NukerCmd()
  : debug (false)
{
}

void NukerCmd::readOneArg(int &argc, char **&argv) {
  int old_argc = argc;
  OinkCmd::readOneArg(argc, argv);
  if (old_argc != argc) return; // the superclass read one so we don't

  char *arg = argv[0];
  // please prefix the names of flags with arguments with '-d-'
  if (streq(arg, "-re-debug")) {
    shift(argc, argv);
    debug = true;
    return;
  } else if (streq(arg, "-class-list")) {
    shift(argc, argv);
    inputFile = shift(argc, argv);
    return;
  }
}

void NukerCmd::dump() {
  OinkCmd::dump();
  // prcheck arguments
  //
  // the idea here is to make the internal name be the same as the
  // external name with the dashes replaced by underscores
  printf("re-debug: %s\n", boolToStr(debug));
}

void NukerCmd::printHelp() {
  OinkCmd::printHelp();
  printf
    ("prcheck flags:\n"
     "  -re-debug  Print info useful for debugging\n"
     "  -class-list: Classes to process\n"
     "");
}

// push the state out to other places where it is needed; return value
// is true unless there is an error
void NukerCmd::initializeFromFlags() {
  OinkCmd::initializeFromFlags();
}

extern NukerCmd *nukerCmd;


int main(int argc, char **argv) {
  traceAddSys("permissive");
  traceAddFromEnvVar();
  tFac = new TypeFactory_O;
  vFac = new ValueFactory;
  astPrinter = new ASTPrinter_O;
  oinkCmd = nukerCmd = new NukerCmd;
  ExitCode code = NORMAL_ExitCode;
  NukerRunner m;
  m.typePrinter = &typePrinterOink;
  try {
    m.init_stage(argc, argv);
    CCParse_Oink ccParse(globalStrTable, globalLang);
    m.parseUserActions = &ccParse;
    m.parseEnv = &ccParse;
    m.parse_stage();
    m.typecheck_stage();
    m.elaborate_stage();
    m.run();
  } catch (xBase &e) {
    cerr << e << endl;
    code = INTERNALERROR_ExitCode;
    if (UserError *ue = dynamic_cast<UserError*>(&e)) code = ue->exitCode;
  }
  delete nukerCmd;
  return code;
}
