// see License.txt for copyright and terms of use

#include "outparamdel_cmd.h"    // this module
#include "oink_cmd_util.h"      // HANDLE_FLAG
#include "oink_util.h"
#include <cstring>              // strdup
#include <cstdlib>              // atoi

OutparamdelCmd::OutparamdelCmd()
  : debug (false),
    outparamError("NS_ERROR_FAILURE")
{}

void OutparamdelCmd::readOneArg(int &argc, char **&argv) {
  int old_argc = argc;
  OinkCmd::readOneArg(argc, argv);
  if (old_argc != argc) return; // the superclass read one so we don't

  char *arg = argv[0];
  // please prefix the names of flags with arguments with '-d-'
  if (streq(arg, "-od-debug")) {
    shift(argc, argv);
    debug = true;
  } else if (streq(arg, "-od-list")) {
    shift(argc, argv);
    outparamFile = shift(argc, argv);
    return;
  } else if (streq(arg, "-od-error")) {
    shift(argc, argv);
    outparamError = shift(argc, argv);
    return;
  }
}

void OutparamdelCmd::dump() {
  OinkCmd::dump();
  // outparamdel arguments
  //
  // the idea here is to make the internal name be the same as the
  // external name with the dashes replaced by underscores
  printf("pr-debug: %s\n", boolToStr(debug));
}

void OutparamdelCmd::printHelp() {
  OinkCmd::printHelp();
  printf
    ("outparamdel flags:\n"
     "  -od-debug  Print info useful for debugging\n"
     "  -od-list <filename> Required parameter listing functions to rewrite\n"
     "  -od-error NS_ERROR_CONSTANT(or macro) error to be returned when rewriting calls to affected getters with ternaries. Default is NS_ERROR_NO_INTERFACE\n"
     "");
}

// push the state out to other places where it is needed; return value
// is true unless there is an error
void OutparamdelCmd::initializeFromFlags() {
  OinkCmd::initializeFromFlags();
}
