typedef unsigned int PRUint32;
typedef unsigned short PRUint16;
typedef unsigned char PRUint8;
typedef int PRIntn;
typedef PRIntn PRBool;
#define nsnull 0

#ifdef THROWER_TEST
#include "nsresult.h"
#include "nserror.h"
#else
typedef unsigned int nsresult;

#define NS_OK 0
#define NS_ERROR_OUT_OF_MEMORY ((nsresult) 232)
#define NS_CUSTOM_ERROR ((nsresult) 93)
#define NS_ERROR_FAILURE ((nsresult) 3)
#define NS_NOINTERFACE                     ((nsresult) 0x80004002L)
#define NS_ERROR_NO_INTERFACE              NS_NOINTERFACE
#define NS_ERROR_INVALID_POINTER ((nsresult) 0x4242422)
#define NS_ERROR_NULL_POINTER NS_ERROR_INVALID_POINTER
#endif

#define NS_UNLIKELY(x)  (x)
#define NS_LIKELY(x)  (x)
#if 0
#define NS_FAILED(_nsresult) (NS_UNLIKELY((_nsresult) & 0x80000000))
#define NS_SUCCEEDED(_nsresult) (NS_LIKELY(!((_nsresult) & 0x80000000)))
#endif
typedef int PRBool;
inline PRBool NS_FAILED(nsresult const ret) { return !!ret; }
inline PRBool NS_SUCCEEDED(nsresult const ret) { return !ret; }

#define NS_IMETHOD_(type) virtual type
#define NS_IMETHODIMP_(type) type
#define NS_CALLBACK_(_type, _name) _type (* _name)
#define NS_CALLBACK(_name)  NS_CALLBACK_(nsresult, _name)
#define NS_IMETHOD          NS_IMETHOD_(nsresult)
#define NS_IMETHODIMP       NS_IMETHODIMP_(nsresult)
#define PR_BEGIN_MACRO  do {
#define PR_END_MACRO    } while (0)
#define NS_WARNING(x) 
#define NS_ENSURE_TRUE(x, ret)                                \
  PR_BEGIN_MACRO                                              \
  if (NS_UNLIKELY(!(x))) {                                  \
    NS_WARNING("NS_ENSURE_TRUE(" #x ") failed");           \
    return ret;                                            \
  }                                                         \
  PR_END_MACRO

#define NS_ENSURE_ARG_POINTER(arg) \
  NS_ENSURE_TRUE(arg, NS_ERROR_INVALID_POINTER)

#define NS_ENSURE_SUCCESS(code, rv) NS_ENSURE_TRUE(rv == 0, rv)

struct nsID {
  /**
   * @name Identifier values
   */

  //@{
  PRUint32 m0;
  PRUint16 m1;
  PRUint16 m2;
  PRUint8 m3[8];
  //@}

  /**
   * @name Methods
   */

  //@{
  /**
   * Equivalency method. Compares this nsID with another.
   * @return <b>PR_TRUE</b> if they are the same, <b>PR_FALSE</b> if not.
   */

  inline PRBool Equals(const nsID& other) const {
    // One would think that this could be done faster with a really
    // efficient implementation of memcmp(), but evidently no
    // memcmp()'s out there are better than this code.
    //
    // See bug http://bugzilla.mozilla.org/show_bug.cgi?id=164580 for
    // details.

    return (PRBool)
      ((((PRUint32*) &m0)[0] == ((PRUint32*) &other.m0)[0]) &&
       (((PRUint32*) &m0)[1] == ((PRUint32*) &other.m0)[1]) &&
       (((PRUint32*) &m0)[2] == ((PRUint32*) &other.m0)[2]) &&
       (((PRUint32*) &m0)[3] == ((PRUint32*) &other.m0)[3]));
  }

  /**
   * nsID Parsing method. Turns a {xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx}
   * string into an nsID
   */
  //NS_COM_GLUE PRBool Parse(const char *aIDStr);

  /**
   * nsID string encoder. Returns an allocated string in 
   * {xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx} format. Caller should free string.
   */
  //NS_COM_GLUE char* ToString() const;
  //@}
};

typedef nsID nsIID;
#define REFNSIID const nsIID&
