/* Standard "it worked" return value */
static const nsresult NS_OK = ((nsresult)0);
#define NS_ERROR_BASE                      (0xC1F30000)
#define NS_ERROR_MODULE_BASE       2
#define NS_ERROR_GENERATE_FAILURE(module,code) \
    ((nsresult) (((PRUint32)(NS_ERROR_SEVERITY_ERROR)<<31) | ((PRUint32)(module+NS_ERROR_MODULE_BASE_OFFSET)<<16) | ((PRUint32)(code))) )

#define NS_ERROR_GENERATE_SUCCESS(module,code) \
    ((nsresult) (((PRUint32)(NS_ERROR_SEVERITY_SUCCESS)<<31) | ((PRUint32)(module+NS_ERROR_MODULE_BASE_OFFSET)<<16) | ((PRUint32)(code))) )
#define NS_ERROR_SEVERITY_ERROR         1
#define NS_ERROR_MODULE_XPCOM      1
#define NS_ERROR_MODULE_FILES      13
#define NS_ERROR_MODULE_BASE_OFFSET 0x45
#define NS_ERROR_SEVERITY_SUCCESS       0

/* Returned when an instance is not initialized */
static const nsresult NS_ERROR_NOT_INITIALIZED = (NS_ERROR_BASE + 1);

/* Returned when an instance is already initialized */
static const nsresult NS_ERROR_ALREADY_INITIALIZED = (NS_ERROR_BASE + 2);

/* Returned by a not implemented function */
static const nsresult NS_ERROR_NOT_IMPLEMENTED = ( 0x80004001L);

/* Returned when a given interface is not supported. */
static const nsresult NS_NOINTERFACE = ( 0x80004002L);
static const nsresult NS_ERROR_NO_INTERFACE = NS_NOINTERFACE;

static const nsresult NS_ERROR_INVALID_POINTER = ( 0x80004003L);
static const nsresult NS_ERROR_NULL_POINTER = NS_ERROR_INVALID_POINTER;

/* Returned when a function aborts */
static const nsresult NS_ERROR_ABORT = ( 0x80004004L);

/* Returned when a function fails */
static const nsresult NS_ERROR_FAILURE = ( 0x80004005L);

/* Returned when an unexpected error occurs */
static const nsresult NS_ERROR_UNEXPECTED = ( 0x8000ffffL);

/* Returned when a memory allocation fails */
static const nsresult NS_ERROR_OUT_OF_MEMORY = ( 0x8007000eL);

/* Returned when an illegal value is passed */
static const nsresult NS_ERROR_ILLEGAL_VALUE = ( 0x80070057L);
static const nsresult NS_ERROR_INVALID_ARG = NS_ERROR_ILLEGAL_VALUE;

/* Returned when a class doesn't allow aggregation */
static const nsresult NS_ERROR_NO_AGGREGATION = ( 0x80040110L);

/* Returned when an operation can't complete due to an unavailable resource */
static const nsresult NS_ERROR_NOT_AVAILABLE = ( 0x80040111L);

/* Returned when a class is not registered */
static const nsresult NS_ERROR_FACTORY_NOT_REGISTERED = ( 0x80040154L);

/* Returned when a class cannot be registered, but may be tried again later */
static const nsresult NS_ERROR_FACTORY_REGISTER_AGAIN = ( 0x80040155L);

/* Returned when a dynamically loaded factory couldn't be found */
static const nsresult NS_ERROR_FACTORY_NOT_LOADED = ( 0x800401f8L);

/* Returned when a factory doesn't support signatures */
static const nsresult NS_ERROR_FACTORY_NO_SIGNATURE_SUPPORT = (NS_ERROR_BASE + 0x101);

/* Returned when a factory already is registered */
static const nsresult NS_ERROR_FACTORY_EXISTS = (NS_ERROR_BASE + 0x100);


/* For COM compatibility reasons, we want to use exact error code numbers
   for NS_ERROR_PROXY_INVALID_IN_PARAMETER and NS_ERROR_PROXY_INVALID_OUT_PARAMETER.
   The first matches:

     static const nsresult RPC_E_INVALID_PARAMETER = _HRESULT_TYPEDEF_(0x80010010L);
   
   Errors returning this mean that the xpcom proxy code could not create a proxy for
   one of the in paramaters.

   Because of this, we are ignoring the convention if using a base and offset for
   error numbers.

*/

/* Returned when a proxy could not be create a proxy for one of the IN parameters
   This is returned only when the "real" meathod has NOT been invoked. 
*/

static const nsresult NS_ERROR_PROXY_INVALID_IN_PARAMETER = ( 0x80010010L);

/* Returned when a proxy could not be create a proxy for one of the OUT parameters
   This is returned only when the "real" meathod has ALREADY been invoked. 
*/

static const nsresult NS_ERROR_PROXY_INVALID_OUT_PARAMETER = ( 0x80010011L);


/*@}*/

 /* I/O Errors */

 /*  Stream closed */
static const nsresult NS_BASE_STREAM_CLOSED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 2);
 /*  Error from the operating system */
static const nsresult NS_BASE_STREAM_OSERROR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 3);
 /*  Illegal arguments */
static const nsresult NS_BASE_STREAM_ILLEGAL_ARGS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 4);
 /*  For unichar streams */
static const nsresult NS_BASE_STREAM_NO_CONVERTER = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 5);
 /*  For unichar streams */
static const nsresult NS_BASE_STREAM_BAD_CONVERSION = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 6);

static const nsresult NS_BASE_STREAM_WOULD_BLOCK = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_BASE, 7);


static const nsresult NS_ERROR_FILE_UNRECOGNIZED_PATH = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 1);
static const nsresult NS_ERROR_FILE_UNRESOLVABLE_SYMLINK = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 2);
static const nsresult NS_ERROR_FILE_EXECUTION_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 3);
static const nsresult NS_ERROR_FILE_UNKNOWN_TYPE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 4);
static const nsresult NS_ERROR_FILE_DESTINATION_NOT_DIR = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 5);
static const nsresult NS_ERROR_FILE_TARGET_DOES_NOT_EXIST = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 6);
static const nsresult NS_ERROR_FILE_COPY_OR_MOVE_FAILED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 7);
static const nsresult NS_ERROR_FILE_ALREADY_EXISTS = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 8);
static const nsresult NS_ERROR_FILE_INVALID_PATH = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 9);
static const nsresult NS_ERROR_FILE_DISK_FULL = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 10);
static const nsresult NS_ERROR_FILE_CORRUPTED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 11);
static const nsresult NS_ERROR_FILE_NOT_DIRECTORY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 12);
static const nsresult NS_ERROR_FILE_IS_DIRECTORY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 13);
static const nsresult NS_ERROR_FILE_IS_LOCKED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 14);
static const nsresult NS_ERROR_FILE_TOO_BIG = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 15);
static const nsresult NS_ERROR_FILE_NO_DEVICE_SPACE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 16);
static const nsresult NS_ERROR_FILE_NAME_TOO_LONG = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 17);
static const nsresult NS_ERROR_FILE_NOT_FOUND = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 18);
static const nsresult NS_ERROR_FILE_READ_ONLY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 19);
static const nsresult NS_ERROR_FILE_DIR_NOT_EMPTY = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 20);
static const nsresult NS_ERROR_FILE_ACCESS_DENIED = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_FILES, 21);

static const nsresult NS_SUCCESS_FILE_DIRECTORY_EMPTY = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_FILES, 1);

 /* Result codes used by nsIDirectoryServiceProvider2 */

static const nsresult NS_SUCCESS_AGGREGATE_RESULT = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_FILES, 2);

 /* Result codes used by nsIVariant */

static const nsresult NS_ERROR_CANNOT_CONVERT_DATA = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM,  1);
static const nsresult NS_ERROR_OBJECT_IS_IMMUTABLE = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM,  2);
static const nsresult NS_ERROR_LOSS_OF_SIGNIFICANT_DATA = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM,  3);

static const nsresult NS_SUCCESS_LOSS_OF_INSIGNIFICANT_DATA = NS_ERROR_GENERATE_SUCCESS(NS_ERROR_MODULE_XPCOM,  1);

/**
 * Various operations are not permitted during XPCOM shutdown and will fail
 * with this exception.
 */
static const nsresult NS_ERROR_ILLEGAL_DURING_SHUTDOWN = NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_XPCOM, 30);
