#ifndef NSRESULT_H
#define NSRESULT_H

class nsresult {
  unsigned int val;
public:
  nsresult() {} 
  nsresult(unsigned int v):val(v) {};
  operator unsigned int() const 
  {
    return val;
  }

  operator bool() const {
    return val;
  }

  bool equals(const nsresult &o) const {
    return o.val == val; 
  }

  nsresult operator! () const{
    return !val;
  }
  
  nsresult operator& (unsigned int o) const {
    return val & o;
  }

  nsresult operator>> (int x) const {
    return val >> x;
  }
};

#if !defined(__cplusplus) && defined(_MSC_VER)
#define NS_INLINE __inline
#else
#define NS_INLINE inline
#endif

NS_INLINE bool operator==(const nsresult &a1, const nsresult &a2) {
  return a1.equals(a2);
}

NS_INLINE bool operator!=(const nsresult &a1, const nsresult &a2) {
  return !a1.equals(a2);
}

#endif // NSRESULT_H
