// see License.txt for copyright and terms of use

// Process command-line arguments.

#ifndef RENAMER_CMD_H
#define RENAMER_CMD_H

#include "oink.h"
#include "oink_cmd.h"
#include "oink_file.h"          // File

class RenamerCmd : public virtual OinkCmd {
  public:
  bool debug; // printout more info
  struct {
    // using StringRef for fast/easy compares
    StringRef from;
    int fromLen;
    // full name including namespace
  // ie sm::string
    std::string to;
    //this ends up as string..ie last part after ::
    std::string toShort;
  } renameClass;


  RenamerCmd();

  void readOneArg(int &argc, char **&argv);
  void dump();
  void printHelp();
  void initializeFromFlags();
  void run();
};

class RenamerRunner : public virtual Oink {
public:
  void run();
};
#endif // RENAMER_CMD_H
