// see License.txt for copyright and terms of use

// Just the main() function.

#include "renamer_cmd.h"
#include "oink.gr.gen.h"        // CCParse_Oink
#include "trace.h"
#include "oink_util.h"
#include "oink_global.h"

using namespace std;

RenamerCmd::RenamerCmd()
  : debug (false)
{
  renameClass.from = NULL;
  renameClass.fromLen = 0;
}

void RenamerCmd::readOneArg(int &argc, char **&argv) {
  int old_argc = argc;
  OinkCmd::readOneArg(argc, argv);
  if (old_argc != argc) return; // the superclass read one so we don't

  char *arg = argv[0];
  // please prefix the names of flags with arguments with '-d-'
  if (streq(arg, "-re-debug")) {
    shift(argc, argv);
    debug = true;
    return;
  } else if (streq(arg, "-rename")) {
    shift(argc, argv);
    renameClass.from = globalStrTable(shift(argc, argv));
    renameClass.fromLen = strlen(renameClass.from);
    renameClass.to = shift(argc, argv);
    if (char *p = strrchr(renameClass.to.c_str(), ':'))
      renameClass.toShort = p + 1;
    else
      renameClass.toShort = renameClass.to;
    return;
  }
}

void RenamerCmd::dump() {
  OinkCmd::dump();
  // prcheck arguments
  //
  // the idea here is to make the internal name be the same as the
  // external name with the dashes replaced by underscores
  printf("re-debug: %s\n", boolToStr(debug));
}

void RenamerCmd::printHelp() {
  OinkCmd::printHelp();
  printf
    ("prcheck flags:\n"
     "  -re-debug  Print info useful for debugging\n"
     "  -rename: <from> <to>\n"
     "");
}

// push the state out to other places where it is needed; return value
// is true unless there is an error
void RenamerCmd::initializeFromFlags() {
  OinkCmd::initializeFromFlags();
}

extern RenamerCmd *renamerCmd;


int main(int argc, char **argv) {
  traceAddSys("permissive");
  traceAddFromEnvVar();
  tFac = new TypeFactory_O;
  vFac = new ValueFactory;
  astPrinter = new ASTPrinter_O;
  oinkCmd = renamerCmd = new RenamerCmd;
  ExitCode code = NORMAL_ExitCode;
  RenamerRunner m;
  m.typePrinter = &typePrinterOink;
  try {
    m.init_stage(argc, argv);
    CCParse_Oink ccParse(globalStrTable, globalLang);
    m.parseUserActions = &ccParse;
    m.parseEnv = &ccParse;
    m.parse_stage();
    m.typecheck_stage();
    m.elaborate_stage();
    m.run();
  } catch (xBase &e) {
    cerr << e << endl;
    code = INTERNALERROR_ExitCode;
    if (UserError *ue = dynamic_cast<UserError*>(&e)) code = ue->exitCode;
  }
  delete renamerCmd;
  return code;
}
