#Some convenient rules for testing rewriting stuff
CXX = $(shell which g++-3.4 2> /dev/null || which g++34) 

# %.diff triggers rewrite of the .cpp...hacky
%.o: %.cpp %.diff %.ii 
	$(CXX) $(CXXFLAGS) -c $<

%.diff: %.ii %.cpp
	$(TOOL) $< > $@
	patch -p0 < $@

%.ii: %.cpp
	$(CXX) -E -o $@ $< $(CXXFLAGS) -Wp,-K

#verify the input compiles
#mark output as readonly to avoid accidental manual changes later
%.cpp: %.cc $(TOOL)
	rm -f $@
	$(CXX) $(CXXFLAGS) -c $<
	cp $< $@
	chmod -w $@

clean:
	rm -f *.o *~ *.ii *.exe *.cpp *.diff

#get rid of default make rules
.SUFFIXES:
