#pragma once

#include "grouping.h"
#include <GLUT/glut.h>
#include <map>


class Grouping;
class PointCloud;
class Point2d;


class VisualGrouping											//Encodes a set of smooth, shaded shapes that cover some region of 2D space.
{																//Typically, such shapes are used to show the visual grouping of some 2D elements.
public:

struct  Cushion													//A cushion is the implem-mechanism for a single set of points
{
		   Cushion(float* ht=0,GLuint tid=0,float sv=0,bool n=true):height(ht),tex_id(tid),scalar_value(sv),normalized(n) {}
	float* height;												//The height-profile of this cushion: -1=outside cushion; 0>=h>=1: cushion height
	GLuint tex_id;												//GL texture id for a texture storing the rendering of this cushion
	float  scalar_value;										//A user-given value in [0,1], used for coloring the shape
	bool   normalized;
};

typedef std::map<int,Cushion>  Group2Tex;						//All cushions in this group, keyed by group-ID

enum CUSHION_TYPE
{  CUSHION_BORDER=0, CUSHION_FULL };

				 VisualGrouping();
				~VisualGrouping();
void			 init(Grouping*);			
Cushion*		 getCushion(int=-1);
void			 setCushion(int,float*,bool normalized);
void			 makeTextures();
void			 clear();
void			 draw(Cushion*,float alpha,bool coloring,bool tex_interp);	
int				 cushionAtPoint(const Point2d&) const;			//Get ID of tallest cushion at given point (-1 if no cushion there)
Grouping::PointGroup											//Get all points visually inside the i-th cushion
				 groupAtPoint(int gid);

float					cushion_shading_thickness;
CUSHION_TYPE			cushion_type;
Group2Tex				group2tex;
Grouping*				grouping;	
PointCloud*				cloud;
GLuint*					texids;
};


