#include <math.h>
#include <algorithm>
#include <GLUT/glut.h>
#include "include/io.h"
#include "include/pointcloud.h"



using namespace std;


void float2rgb(float value,float& R,float& G,float& B,bool color_or_grayscale)	//simple color-coding routine
{
   if (!color_or_grayscale)
   { 
	 R = G = B = value;
   }	 
   else
   {
     const float dx=0.8f;

     value = (6-2*dx)*value+dx;
     R = max(0.0f,(3-(float)fabs(value-4)-(float)fabs(value-5))/2);
     G = max(0.0f,(4-(float)fabs(value-2)-(float)fabs(value-4))/2);
     B = max(0.0f,(3-(float)fabs(value-1)-(float)fabs(value-2))/2);
   }	 
}

		
void glutDrawString(const char* s)
{
  while (*s) glutBitmapCharacter(GLUT_BITMAP_HELVETICA_10,*s++);
}


void glVertex2f(const Point2d& p)
{
	glVertex2f(p.x,p.y);
}

void drawSplat(const Point2d& p,float rad)		//Draw a splat (current texture) on a radius of 'rad' pixels centered at 'c'
{
		glTexCoord2f(0,0);											
		glVertex2f(p.x-rad,p.y-rad);
		glTexCoord2f(1,0);
		glVertex2f(p.x+rad,p.y-rad);
		glTexCoord2f(1,1);
		glVertex2f(p.x+rad,p.y+rad);
		glTexCoord2f(0,1);
		glVertex2f(p.x-rad,p.y+rad);
}

void setTexture(GLuint tex_id,bool tex_interp)
{
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, tex_id);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, (tex_interp)?GL_LINEAR:GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, (tex_interp)?GL_LINEAR:GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
}

void drawCircle(const Point2d& c,float rad)
{
	const int N = 30;
	
	glBegin(GL_LINE_LOOP);
	for(int i=0;i<N;++i)
	{
	   float alpha = 2*M_PI*float(i)/N;	
	   float x = rad*cos(alpha);
	   float y = rad*sin(alpha);
	   glVertex2f(c.x+x,c.y+y);
	}	
	glEnd();
	
}