#pragma once
#include "Volume.h"
#include <vector>

class ImportanceVolume
{
  Volume<float>& importance;
  int size;
  std::vector<float> sortedImportancePoints;

  float largestDifferenceThreshold;
  float maxImportance;
  float minImportance;

public:
  ImportanceVolume(Volume<float>& imp, int size);

  float GetEqualizedImportance(float normThreshold);

  float GetLargestDifferenceThreshold();

  float GetMaxImportance();

  float GetMinImportance();

  Volume<float>& GetInnerVolume();

private:
  std::vector<float> createImportanceIndex(Volume<float>& imp, int size);

  std::vector<float> getSortedImportancePoints();

  float findLargestDifferenceThreshold(std::vector<float> allImportancePoints);
};
