#pragma once
#include "Volume.h"
#include "surface/Graph.h"
#include "SkeletonModel.h"
#include <random>

enum class NoisePickType
{
  Convex = 1,
  Concave = 2
};

enum class NoiseShape
{
  Cube,
  Ball,
  Gaussian
};

class NoiseCreator
{
  Volume<byte>& input;
  surface::Graph& graph;
  std::shared_ptr<SkeletonModel> inputModel;
  std::unordered_map<coord3s, Point3d> normalsMap;

  std::default_random_engine generator;
	
public:
  NoiseCreator(Volume<byte>& input, surface::Graph& graph, std::shared_ptr<SkeletonModel> inputModel);

  void AddRandomStripe(NoisePickType noiseType, NoiseShape shape, coord3s start, float radius, int height, int length);
  void AddSingle(NoisePickType noiseType, NoiseShape shape, coord3s point, float radius);
  void AddSingleLine(NoisePickType noiseType, NoiseShape shape, coord3s point, float radius, Point3d* normal = nullptr, int length = 1);
  void AddSingleLineSurface(NoisePickType noiseType, NoiseShape shape, coord3s point, float radius, int height);
  void GeneratePoints(double probability, NoisePickType noiseType, NoiseShape shape, float radius, int height = 1, int length = 1, int seed = 0);
  void CalculateNormalMap();

private:
  Point3d getRandomSphericalDir();
  Point3d getRandomTangentDir(Point3d normal);
};
