#pragma once


#include "Point3d.h"
#include "ANN/ANN.h"
#include <vector>
#include <mutex>



class PointSearch                   //Simple class to search closest points in a point-cloud
{
  //Uses internally the fast KD-tree method from the ANN library
  static std::mutex s_mtx;
public:
  PointSearch(const std::vector<Point3d> &points, int Nmax);
  //Initialize the search engine to work with the vertices of the given grid.
  //Nmax gives the maximum number of closest-points we are allowed to search for.

  ~PointSearch();

  void      closest(int N, const Point3d &p, std::vector<int> &indexes,
                    std::vector<float> &distances);
  //Returns the N-closest grid-vertices to a search point 'p'. N must be smaller than Nmax (see constructor).
  //Vertex indices (in the grid) and their distances to 'p' are returned in the indexes[]
  //and distances[] arrays, in increasing order of distance to the search point 'p'.

  int       closest(const Point3d
                    &p);        //Cheaper/faster version of above: returns idx of closest point to p.

  void      closest(float R, const Point3d &p, std::vector<int> &indexes,
                    std::vector<float> &distances);
  //Returns the grid-vertices which are within a radius R to a search point 'p'. The maximum
  //number of returned points is Nmax (see constructor).
  //Vertex indices (in the grid) and their distances to 'p' are returned in the indexes[]
  //and distances[] arrays, in increasing order of distance to the search point 'p'.



protected:

  ANNidxArray
  nn_idx;               //Buffer for getting the nearest-neighbors from the ANN library
  ANNdistArray
  nn_distances;           //Buffer for getting distances to nearest-neighbors from the ANN library
  ANNpointArray
  data_pts;             //Buffer for storing 3D grid-vertex coordinates for the ANN library
  ANNkd_tree*
  kdt;                //KD-tree constructed by the ANN library for fast searching
  int
  Nmax;               //Maximum #closest-points the closest() methods can return
};


