#pragma once
#include "Volume.h"
#include "SkeletonModel.h"
#include "FeaturePoints.h"
#include "surface/AStar.h"

class SaliencyMetricEngine
{
	FeaturePoints& featurePoints;
	Volume<float>& edt;
  Volume<float>& importance;


public:
  SaliencyMetricEngine(FeaturePoints& featurePoints, Volume<float>& edt,
                       Volume<float>& importance);

  Volume<float> Compute(float impThreshold);
  Volume<float> ComputeDerivative(Volume<Vector>& velocity, surface::Graph& graph, float impThreshold, float derThreshold = 1.0f);
  Volume<float> ComputeDerivativeCombiMeasure(Volume<Vector>& velocity, surface::Graph& graph, float impThreshold, float salThreshold);
  Volume<float> ComputeDerivativeDirect(Volume<Vector>& velocity, surface::Graph& graph, float derThreshold = 1.0f);
  Volume<float> ComputeDerivativeGradient(Volume<Vector>& velocity, surface::Graph& graph);
  Volume<float> ComputeReverseEDT(std::shared_ptr<SkeletonModel> skeletonModel, float impThreshold);
  Volume<float> ComputeStreamlines(Volume<Vector>& velocity, surface::Graph& graph, float impThreshold);
  Volume<float> ComputeGlobalMonotonic(Volume<Vector>& velocity, surface::Graph& graph, float impThreshold);

  Volume<float> ComputeGeodesic(surface::Graph& graph);
  Volume<float> ComputeGeodesicRaw(surface::Graph& graph, bool useEstimate = false);

  Volume<float> ComputeEstimatedEuclidean(float preThreshold);

  Volume<Vector> BuildFeatureVelocity(surface::Graph& graph);
  Volume<Vector> BuildGradientEdtVelocity(surface::Graph& graph);
  Volume<Vector> BuildGradientImpVelocity(surface::Graph& graph, Volume<float>& importance);

  coord3s FindVelocityCoord(coord3s point, float impThreshold, Vector velocity);
  coord3s FindVelocityCoordHighDerivative(Volume<float>* derivative, FeaturePoints::Coord2SKP& map,
    surface::Graph& graph, Volume<Vector>& velocityField, coord3s point, float impThreshold, Vector velocity, float derThreshold);

  coord3s FindTangentNext(size_t index, Volume<Vector>& velocity, surface::Graph & graph, float impThreshold, int distFallover = 3);
  coord3s FindTangentNextHighDerivative(Volume<float>* derivative, size_t index, FeaturePoints::Coord2SKP& map,
    Volume<Vector>& velocity, surface::Graph & graph, float impThreshold, float derTHreshold, int distFallover = 3);


  float TraceVelocityStreamLine(Volume<float>* derivative, size_t index, Volume<Vector>& velocity, surface::Graph& graph,
    float impThreshold, FeaturePoints::Coord2SKP& map, std::vector<coord3s>* outPoints);

  std::pair<coord3s, coord3s> GetWidestFeaturePoints(surface::Graph& graph, size_t fpIndex);
  Point3d GetOrthoCenter(surface::Graph& graph, size_t fpIndex);
  float GetSingleDerrivative(size_t index, surface::Graph& graph, Volume<Vector>& velocity, float impThreshold, float salThreshold);
  coord3s TraceBackwards(size_t index, surface::Graph& graph, Volume<Vector>& velocity,
    float impThreshold, int steps);
  coord3s TraceBackwardsDirect(size_t index, surface::Graph& graph, Volume<Vector>& velocity, int steps);

  float estimateShortestPathLength(coord3s origin, coord3s target, float accuracy);
  float estimateFeatureLength(coord3s origin);

private:
  float DistbetweenFeaturePoints(surface::AStar& aStarEngine, size_t index);
  float TraceSingleMonotonic(size_t index, surface::Graph& graph, Volume<Vector>& velocity,
    float impThreshold, FeaturePoints::Coord2SKP& map, const Volume<float>& saliency, Volume<float>& angleMetric,
    SimpleVolume<coord3s>& history);

};

enum class SaliencyMethod
{
  Classical,
  Derrivative,
  InvFeature,
  Streamline,
  GlobalImportance
};
