#ifndef SKELETONMODEL_H
#define SKELETONMODEL_H
#include <vector>
#include "Point3d.h"
#include "Volume.h"
#include "coord3.h"
#include "collapseSkel3d.h"
#include "SkeletonReconstructor.h"
#include "PointSearch.h"
#include <memory>


class SkeletonModel
{
  //skeleton points of the currently-simplified skeleton
  //Fields under this is the input of the SkeletonModel, 
  //and will be refactored to its own class (sooner or later)
  Volume<float> *importance;
  const Volume<float> &edt;
  const Volume<byte>  &thinImage;
  int width, height, depth;
  float maxDistance;
  float impThreshold;


  //collapsed points of the current collapse step
  std::vector<Point3d> skelPoints;
  std::vector<Point3d> thinPoints;
  std::vector<Point3d> skelNormals;
  std::vector<Point3d> thinNormals;

  //kd-tree for input boundary surface
  std::unique_ptr<PointSearch> skelPointSearch;

public:
  SkeletonModel(collapseSkel3d& skelEngine, float impThreshold, bool build = true);
  ~SkeletonModel();
  void Update(collapseSkel3d& skelEngine, float impThreshold, const Volume<float> &importance, bool keepLargest);
  void Update(collapseSkel3d& skelEngine, float impThreshold);
  void Update(collapseSkel3d& skelEngine);
  std::shared_ptr<SkeletonModel> Reconstruct(collapseSkel3d& skelEngine, 
    ReconstructionSmoothingType smoothing, int radius, Volume<byte>& outRecon);
  std::shared_ptr<SkeletonModel> Reconstruct(collapseSkel3d& skelEngine,
    ReconstructionSmoothingType smoothing, int radius,
    surface::Graph& graph, FeaturePoints& featurePoints, Volume<byte>& outRecon);
  std::vector<Point3d> CreateThickSet();
  Volume<float> SmoothLeastSquares();


  std::vector<Point3d>& GetSkelPoints() { return skelPoints; }
  std::vector<Point3d>& GetThinPoints() { return thinPoints; }
  std::vector<Point3d>& GetSkelNormals() { return skelNormals; }
  std::vector<Point3d>& GetThinNormals() { return thinNormals; }

  PointSearch& getSkelPointSearch();

private:
  std::vector<Point3d> createThinSet(float impThresh, const Volume<byte>& thinImage);
  std::vector<Point3d> createSkeletonPoints(const Volume<float>& importance, float impThresh);
  void createNormals(const Volume<byte>& thinImage, std::vector<Point3d>& points, const Volume<float>& importance,
    std::vector<Point3d>& normals, float impThr, const int NSZ = 2);
};

#endif // SKELETONMODEL_H
