#pragma once

#include "edt3d.h"
#include <math.h>
#include <algorithm>
#include <memory>
#include "Point3d.h"

#ifdef _WIN32
#define FORCE_INLINE __forceinline
#elif __GNUC__
#define FORCE_INLINE __attribute__((always_inline)) inline
#else
#define FORCE_INLINE inline
#endif


class FeaturePoints;
namespace surface
{
  class Graph;
}

enum class ReconstructionSmoothingType
{
  None,
  Linear,
  Median,
  Min,
  Opening,
  HalfConstrainedOpening,
  LeastSquares,
  FlatProjectionEdt,
  FlatProjectionPosition,
  FlatProjectionBoth
};



/* sdt_x becomes inverse squared euclidian distance transform of v.
sdt_x must already have been initialized to the same dimensions as v.
*/
void InvEdt(Volume<int>& sdt_x, Volume<byte>& v, const Volume<float>& old_edt);


// todo: make compatible with importance volumes
class SkeletonReconstructor
{
  const std::vector<Point3d>& skelPoints;
  const Volume<float> &edt;

  Volume<byte> skeletonMask;
public:

	SkeletonReconstructor(const std::vector<Point3d>& skelPoints, const Volume<float> &edt);

  Volume<byte> Reconstruct(ReconstructionSmoothingType smoothingType, int radius,
    const Volume<float>* imp = nullptr, float threshold = 0, surface::Graph* graph = nullptr,
    FeaturePoints* featurePoints = nullptr, bool constrainSearchToSkeleton = false);
  Volume<byte> Reconstruct(SimpleVolume<coord3s>& ift_out);
  Volume<byte> Reconstruct(SimpleVolume<coord3s>& ift_out, const Volume<float>& edt);

  void InitSkeletonMask();

private:
  Volume<float> LeastSquaresProjection(const Volume<float>& imp, float threshold, int r);
  Volume<float> FlatProjectionEdt(const Volume<float>& saliency, FeaturePoints& featurePoints,  
    surface::Graph& graph, float threshold, int r);
  void FlatProjectionPosition(const Volume<float>& saliency, FeaturePoints& featurePoints,
    surface::Graph& graph, float threshold, int r);

};



