#pragma once
#include <type_traits>
#include <vector>


//class implementing Union Find Data Structure with Path Compression
template <class T>
class UnionFind
{
  std::vector<T> id;
  std::vector<T> sz;

  T count;
public:

  UnionFind(T n)
    : count(n)
  {
    id.resize(n);
    sz.resize(n);

    for (int i = 0; i < n; ++i)
    {
      id[i] = i;
      sz[i] = 1;
    }
  }

  int root(T i)
  {
    while (i != id[i])
    {
      id[i] = id[id[i]];	//path Compression
      i = id[i];
    }
    return i;
  }

  bool find(T p, T q)
  {
    return root(p) == root(q);
  }

  void merge(T p, T q)
  {
    int i = root(p);
    int j = root(q);

    if (sz[i] > sz[j])
    {
      id[j] = i;
      sz[i] += sz[j];
    }
    else
    {
      id[i] = j;
      sz[j] += sz[i];
    }
    --count;
  }


  T getLargestLabel()
  {
    T label = -1;
    T size = -1;

    for (T t : id)
    {
      if (size < sz[t])
      {
        label = t;
        size = sz[t];
      }
    }

    return label;
  }

  T getSize(T label)
  {
    return sz[label];
  }

  T getLabel(T key)
  {
    return id[key];
  }

  T getCount()
  {
    return count;
  }

};
