#pragma once

#include <math.h>

struct Vector
{
  float u, v, w;

  Vector() { u = 0; v = 0; w = 0; }
  Vector(float u_, float v_, float w_): u(u_), v(v_), w(w_) {}

  Vector &operator+=(const Vector &a)
  {
    u += a.u;
    v += a.v;
    w += a.w;
    return *this;
  }

  Vector &operator-=(const Vector &a)
  {
    u -= a.u;
    v -= a.v;
    w -= a.w;
    return *this;
  }

  float norm() const
  {
    return sqrtf(u * u + v * v + w * w);
  }

  float norm2() const
  {
    return u * u + v * v + w * w;
  }
};




