#pragma once
#include "Volume.h"
#include "ComponentFinder.h"
#include "CIsoSurface.h"

template <class T>
void FilterLargestComponent(Volume<T>& volume, T threshold = 0)
{
  ComponentFinder<T> componentFinder(volume, threshold);

  componentFinder.findAll();
  int label = componentFinder.getLargestLabel();

  for (int z = 1; z < volume.getDepth() - 1; z++)
    for (int y = 1; y < volume.getHeight() - 1; y++)
      for (int x = 1; x < volume.getWidth() - 1; x++)
        if (componentFinder.getLabel(x, y, z) != label)
          volume(x, y, z) = 0;
}



template <class T>
Vector ComputeGradient(const Volume<T>& v, coord3s p)
{
  float gx = 0.0f, gy = 0.0f, gz = 0.0f;

  gx = (v(p.x + 1, p.y, p.z ) - v(p.x - 1, p.y, p.z ));
  gy = (v(p.x, p.y + 1, p.z ) - v(p.x, p.y - 1, p.z ));
  gz = (v(p.x, p.y, p.z + 1) - v(p.x, p.y, p.z - 1));

  float length = sqrtf(gx * gx + gy * gy + gz * gz) + 1e-7f;
  Vector vec(p.x, p.y, p.z);
  vec.u = gx / length;
  vec.v = gy / length;
  vec.w = gz / length;
  return vec;
}

inline bool ExportVolumeToObj(std::string filename, Volume<byte>& volume)
{
  std::unique_ptr<std::vector<byte>> vec(new std::vector<byte>);

  //Generate isosurface
  CIsoSurface<byte> surf;
  volume.toVector(*vec);
  surf.GenerateSurface(&(*vec)[0], 1,
    volume.getWidth() - 1,
    volume.getHeight() - 1,
    volume.getDepth() - 1,
    1.0, 1.0, 1.0);

  if (!surf.IsSurfaceValid())
  {
    std::cerr << "CIsoSurface: Couldn't generate a valid surface." << std::endl;
    return false;
  }

  surf.ExportToObj(filename);
  return true;
}
