#pragma once
#include <iostream>
#include <cstdint>

template <class T>
struct coord3
{
  T x, y, z;

  template <class otherT>
  bool operator==(const coord3<otherT> &a) const
  {
    return (a.x == x) && (a.y == y) && (a.z == z);
  }

  template <class otherT>
  bool operator<(const coord3<otherT> &a) const       //lexicografic compare
  {
    if (z < a.z) return true;
    if (z > a.z) return false;
    if (y < a.y) return true;
    if (y > a.y) return false;
    if (x < a.x) return true;
    return false;
  }

  int lengthSquared()
  {
    return x * x + y * y + z * z;
  }

  template <class otherT>
  coord3<T> operator- (const coord3<otherT>& rhs) const
  {
    return coord3<T>(x - rhs.x, y - rhs.y, z - rhs.z);
  }

  template <class otherT>
  T dot (const coord3<otherT>& rhs) const
  {
    return x * rhs.x + y * rhs.y + z * rhs.z;
  }

  template <class otherT>  
  coord3<T> operator+ (const coord3<otherT>& rhs) const
  {
    return coord3<T>(x + rhs.x, y + rhs.y, z + rhs.z);
  }

  template <class otherT>
  void operator-= (const coord3<otherT>& rhs)
  {
    x -= rhs.x; y -= rhs.y, z -= rhs.z;
  }

  template <class otherT>
  void operator+= (const coord3<otherT>& rhs)
  {
    x += rhs.x; y += rhs.y, z += rhs.z;
  }

  template <class otherT>
  coord3<T> cross(const coord3<otherT>& rhs) const
  {
    return coord3<T>(y * rhs.z - rhs.y * z, rhs.x * z - x * rhs.z, x * rhs.y - rhs.x * y);
  }

  coord3<T>() {}
  coord3<T>(T xx, T yy, T zz) : x(xx), y(yy), z(zz) {};
};


typedef coord3<int16_t> coord3s;
typedef coord3<int32_t> coord3i;
typedef coord3<float> coord3f;
typedef coord3<double> coord3d;

template <class T>
inline std::ostream& operator<<(std::ostream& stream, coord3<T> const& f)
{
  return stream << "(" << f.x << ", " << f.y << ", " << f.z << ")";
}

namespace std {

  template <class T>
  struct hash<coord3<T>>
  {
    std::size_t operator()(const coord3<T>& k) const
    {
      using std::hash;

      return 
         (hash<uint32_t>()(k.z * 1000 * 1000 + k.y * 1000 + k.x  ));
    }
  };

} 