#pragma once

#include "surface/Graph.h"
#include <memory>

namespace cuts
{

class Cut
{
public:
  ///All points on the cut, saved as a set of Nodes nodes on the surface Graph.
  std::unique_ptr<surface::Graph::Path> up_path;
  ///The index of the skeletonpoint to wich this cut corresponds.
  size_t d_skelpoint_idx;

  void swap(Cut &other)
  {
    using std::swap;
    swap(up_path, other.up_path);
    swap(d_skelpoint_idx, other.d_skelpoint_idx);
  }

  Cut(){}

  Cut(const Cut &other)
  :
    up_path(std::make_unique<surface::Graph::Path>(*other.up_path)),
    d_skelpoint_idx(other.d_skelpoint_idx)
  {}

  Cut(Cut &&other)
  :
    Cut()
  {
    swap(other);
  }

  Cut& operator=(Cut other)
  {
    swap(other);
    return *this;
  }
};

inline void swap(Cut &l, Cut &r)
{
  l.swap(r);
}

}
