#pragma once

#include "CutCreator.h"
#include "CutSet.h"
#include "Transform.h"

#include <memory>

namespace cuts
{

class CutController
{
  std::unique_ptr<CutSet>     up_cutSet;
  std::unique_ptr<CutCreator> up_cutCreator;
  std::unique_ptr<Transform>  up_transform;

public:
  enum class Method
  {
    SHORTESTPATH,
    PLANETRACE,
    PERPTOSKEL,
    EDTFIT
  };

  enum class TransformMethod
  {
    LAPLACIANSMOOTHING
  };

  void compute();
  void transform();

  //getters and setters
  CutSet &getCutSet();
  void setCutSet(std::unique_ptr<CutSet> value);

  CutCreator &getCutCreator();
  void setCutCreator(std::unique_ptr<CutCreator> value);

  Transform &getTransform();
  void setTransform(std::unique_ptr<Transform> value);

  bool hasCutSet() {return static_cast<bool>(up_cutSet);}
  bool hasCutCreator() {return static_cast<bool>(up_cutCreator);}
  bool hasTransform() {return static_cast<bool>(up_transform);}
};

}
