#pragma once

class FeaturePoints;
namespace surface{class Graph;}
class collapseSkel3d;

#include <memory>

namespace cuts
{

class Cut;

class CutCreator
{
protected:
  const FeaturePoints   &r_fp;
  const surface::Graph  &r_surfaceGraph;
  const collapseSkel3d  &r_skel;
public:
  CutCreator(const FeaturePoints &fp, const surface::Graph &sufaceGraph, const collapseSkel3d &skel);
  virtual ~CutCreator(){}

  /// Compute the cut corresponding to
  /// @param skelpoint_idx the index of the skeletonpoint in the vector containing the full skeleton
  /// @see Cut
  virtual std::unique_ptr<Cut> operator()(size_t skelpoint_idx) = 0;
};


}
