#pragma once

#include "cuts/CutCreator.h"
#include "cuts/Cut.h"
#include <map>
#include <memory>
#include <chrono>

class SkeletonModel;

namespace cuts
{
class CutSet
{
  FeaturePoints &r_fp;
  SkeletonModel &r_skeletonModel;
  std::map<size_t, std::unique_ptr<Cut>> d_cuts;

public:
  CutSet(FeaturePoints &fp, SkeletonModel &skeletonModel);
  CutSet(const CutSet &other);
  CutSet(CutSet &&other);


  ///(re)computes all the cuts given a cutcreator
  void compute(CutCreator &cutCreator);

  std::map<size_t,std::unique_ptr<Cut>> &getCuts()
  {
    return d_cuts;
  }

  //unary operator Cut->Cut
  template <class UnaryOperator>
  std::unique_ptr<CutSet> transform(UnaryOperator const &op)
  {
    std::cout << "applying transform to cutset\n";
    auto transformedSet = std::make_unique<CutSet>(r_fp, r_skeletonModel);
    auto & newCuts = transformedSet->getCuts();
    std::vector<size_t> keys;
    for (auto &kvpair : d_cuts)
      keys.emplace_back(kvpair.first);

    #pragma omp parallel for
    for (int key_idx = 0; key_idx < static_cast<int>(keys.size()); ++key_idx)
    {
      decltype(d_cuts)::iterator it;
      #pragma omp critical
      it = d_cuts.find(keys[key_idx]);
      auto new_pair = std::make_pair(
        it->first,
        std::make_unique<Cut>(op(*(it->second))));
      #pragma omp critical
      newCuts.insert(std::move(new_pair));
    }
    std::cout << "done applying transform to cutset\n";
    return transformedSet;
  }

  std::unique_ptr<CutSet> identityTransform()
  {
    return transform([](Cut cut)->Cut{return cut;});
  }

  //unary predicate Cut->Bool, removes false elements
  template <class UnaryPredicate>
  void filter(UnaryPredicate pred)
  {
    for (auto it = d_cuts.begin(); it != d_cuts.end();)
    {
      if (!pred(it->second))
      {
        d_cuts.erase(it++);
      }
      else
      {
        ++it;
      }
    }
  }
};

}
