#pragma once

#include "cuts/CutCreator.h"
#include "surface/PlaneTrace.h"

#include <vector>

class Point3d;

namespace cuts
{

  /**
 * @brief The PlaneTraceCutCreator class computes a cut from the plane intersection
 *        of the plane going through the skeleton point and the two feature points.
 */
class PlaneTraceCutCreator : public CutCreator
{
protected:
  const std::vector<Point3d> &r_normals;
  size_t d_bandDeviation;
public:
  PlaneTraceCutCreator(
    const FeaturePoints &fp,
    const surface::Graph &sufaceGraph,
    const collapseSkel3d &skel,
    const std::vector<Point3d> &surfaceNormals,
    const size_t bandDeviation = 2);
  virtual ~PlaneTraceCutCreator(){}

  virtual std::unique_ptr<Cut> operator()(size_t skelpoint_idx);

  virtual surface::PlaneTrace::Plane makeCutPlane(size_t skelpoint_idx);
};

}
