#pragma once

#include "surface/Graph.h"
#include "Transform.h"

namespace cuts
{

class TransformLaplacianSmooth : public Transform
{
  const FeaturePoints &r_fp;
  const surface::Graph &r_sufaceGraph;

  const size_t d_NI;     //Number of shrinking+smoothing iterations in one pass
  const size_t d_NS;     //Number of smoothing iterations before back-projection
  const size_t d_maxPass;//Number of maximum passes
  const float d_weight;  //weight p <- p + weight * L(p)
public:
  TransformLaplacianSmooth(
      const FeaturePoints &fp,
      const surface::Graph &sufaceGraph,
      const size_t NI = 10,
      const size_t NS = 2,
      const float weight = 0.75f,
      const size_t maxPass = 20);
  //apply telea's Laplacian smoothing and backprojection method
  Cut operator()(Cut cut) const;
};

}
