/*
*   $Source: /net/users/roe/onderzoek/morphology/skeletons/code/democode/RCS/image.h,v $
*   $Revision: 1.1 $
*   $Date: 2009/06/16 14:19:09 $
*   $State: Exp $
*   $Author: roe $
* 
* ------------------------------------------------------------*/
#ifndef _IMAGE_H
#define _IMAGE_H

namespace IMA
{
  #define IMA_MAXSTR 200
  #define IMA_SQR(a) ((a)*(a))
  #define IMA_PIXEL short
  #define IMA_BYTE unsigned char

  #ifndef IMA_TRUE
  #define	IMA_TRUE 1
  #endif
  #ifndef IMA_FALSE
  #define	IMA_FALSE 0
  #endif

  typedef struct {
    int xdim, ydim;
    unsigned char **data;
  } ByteImage;

  ByteImage *ByteImage_New(int xdim, int ydim);
  void ByteImage_GetMinMax(ByteImage *im, IMA_BYTE *im_min, IMA_BYTE *im_max);
  ByteImage *ByteImage_Crop(ByteImage *im, int factor);
  void ByteImage_Delete(ByteImage *im);
  void ByteImage_CropWrite(ByteImage *im, char name[], int cropfactor);
  void ByteImage_WritePGM(ByteImage *im, char name[]);
}

#endif
