/*
*   $Source: /net/users/roe/onderzoek/morphology/skeletons/code/democode/RCS/volume.h,v $
*   $Revision: 1.1 $
*   $Date: 2009/06/16 14:19:09 $
*   $State: Exp $
*   $Author: roe $
* 
* ------------------------------------------------------------*/
#ifndef _IMAVOLUME_H
#define _IMAVOLUME_H
#include <stdlib.h>
#include <stdio.h>
#include "ima/ImaImage.h"

namespace IMA
{
#define IMA_VOXEL unsigned short
#define IMA_BYTE unsigned char
#define PI 3.1415926535897932384626433
#define MIN(a,b) ((a)<(b) ? (a) : (b))
#define MAX(a,b) ((a)>(b) ? (a) : (b))


#define PR2( f, p)	(void) fprintf ( stdout, f, p)
#define IMA_MAXSTR 200

  typedef struct {
    int xdim, ydim, zdim;
    IMA_VOXEL ***data;
  } Volume;

  typedef struct {
    int xdim, ydim, zdim;
    IMA_BYTE ***data;
  } ByteVolume;

  typedef struct {
    int xdim, ydim, zdim;
    int ***data;
  } IntVolume;

  typedef struct {
    double u, v;
  } PlanarPoint;

  Volume *Volume_New(int xdim, int ydim, int zdim);
  Volume *Volume_ReadSFF(char filename[]);
  ByteVolume *ByteVolume_ReadSFF(char* filename);
  ByteVolume *ByteVolume_ReadVTK(char* filename);
  void Volume_MinMax(Volume *v, IMA_VOXEL *min, IMA_VOXEL *max);
  void Volume_WriteSFF(Volume *v, const char* filename);
  void ByteVolume_WriteVTK(ByteVolume *v, const char* filename);
  ByteVolume *ByteVolume_New(int x, int y, int z);
  void Volume_Delete(Volume *v);
  void ByteVolume_Delete(ByteVolume *v);
  void ByteVolume_MinMax(ByteVolume *v, IMA_BYTE *min, IMA_BYTE *max);
  IntVolume *IntVolume_New(int x, int y, int z);
  void IntVolume_Delete(IntVolume * iv);
  float *vector(int nl, int nh);
  int *ivector(int nl, int nh);
  void free_vector(float *v, int nl, int nh);
  void free_ivector(int *v, int nl, int nh);
  float mean(float *v, int nl, int nh);
  float stdev(float *v, int nl, int nh);
  void ByteVolume_Clear(ByteVolume *v);
  void ByteVolume_Clamp(ByteVolume *v, IMA_BYTE clampval);
  ByteImage *ByteVolume_MIP(ByteVolume *v, double phi, double theta, double alpha, int size);
  PlanarPoint ProjectPoint(double x, double y, double z, double phi, double theta, double alpha);
  void makemip(char *file_name, ByteVolume *v, double phi, double theta, double alpha, int cropfactor);
}
#endif
