#pragma once

#include <vector>
#include <algorithm>


struct LogEntry
{
  int   iteration;
  float tot_density;
  float max_distance;
  float crt_distance;
  int interface_points;
  int eroded_points;

  LogEntry(int i, float td, float md, float cd, int ip, int ep):
    iteration(i), tot_density(td), max_distance(md), crt_distance(cd),
    interface_points(ip), eroded_points(ep)
  { }


};


class LogData : public std::vector<LogEntry>
{
public:
  LogData(): tot_density_max(0), crt_distance_max(0), interface_points_max(0),
    eroded_points_max(0)
  {}

  void  add(const LogEntry &e)
  {
    push_back(e);
    tot_density_max  = std::max(tot_density_max, e.tot_density);
    crt_distance_max = std::max(crt_distance_max, e.crt_distance);
    interface_points_max = std::max(interface_points_max, e.interface_points);
    eroded_points_max = std::max(eroded_points_max, e.eroded_points);
  }


  float tot_density_max;
  float crt_distance_max;
  int interface_points_max;
  int eroded_points_max;
};
