#pragma once

#include "surface/Graph.h"

#include <memory>

namespace surface
{

class AStar
{
  const Graph &r_graph;
public:
  AStar(const surface::Graph &graph);

  ///Given two graph nodes, computes and returns shortest-path between them
  std::unique_ptr<Graph::Path> shortestPath(
      int origin_boundary_idx,
      int target_boundary_idx) const;
  std::unique_ptr<Graph::Path> shortestPath(
      Graph::Node *origin_node,
      Graph::Node *target_node) const;


};

}