#pragma once

#include "surface/Graph.h"

#include <Eigen/Geometry> 
#include <memory>
#include <cmath>

namespace surface
{

class PlaneTrace
{
public:
  typedef Eigen::Hyperplane<double, 3> Plane;
private:
  const surface::Graph  &r_graph;
  const std::vector<Point3d> &r_normals;
public:
  PlaneTrace(const surface::Graph &graph, const std::vector<Point3d> &normals);

  ///Provides a path (ends not connected) following the surface-plane intersection
  ///starting in seed_boundary_index and following plane.
  ///The seed must lie within the threshold distance from the plane
  std::unique_ptr<Graph::Path> trace(
      int seed_boundary_index,
      const Plane &plane,
      double bandDeviation = 2.0);
};

//starting in seed_node, create a new graph that is a subgraph of graph,
//with all the nodes that are within distance distance_thr from the plane,
//and reachable from seed_node with a path that always stays within thr from plane.
std::unique_ptr<Graph> makeCutBand(
  const surface::Graph &input_graph,
  double distance_thr,
  const surface::Graph::Node *seed_node,
  const PlaneTrace::Plane &plane);
}
