#pragma once

#include "Image.h"
#include "coord3.h"

#include <vector>
#include <array>
#include <stdint.h>

class Point3d;
template<class T> class Volume;


void float2rgb(float value, float *col); //simple color-coding routine

std::vector<Point3d> createThinSet(const Volume<byte>& thinImage);

// For vector types such as coord3s, and Point3d
template<class T>
inline uint32_t generateKey(const T& p)
{
  return 1000u * 1000u * static_cast<uint32_t>(p.x)
    + 1000u * static_cast<uint32_t>(p.y)
    + static_cast<uint32_t>(p.z);
}


float AreaTriangleSquared(const Point3d& A, const Point3d& B, const Point3d& C);

Point3d InCenterTriangle(const Point3d& A, const Point3d& B, const Point3d& C);

Point3d InCenterTriangleOrtho(const Point3d& A, const Point3d& B, const Point3d& C);

template <class T>
T Linear(T x, T x0, T x1, T f0, T f1)
{
  return x1 == x0 ? f0 : (x1 - x) / (x1 - x0) * f0 + (x - x0) / (x1 - x0) * f1;
}

template <class T>
T Bilinear(T x, T x0, T x1, T y, T y0, T y1, T f00, T f01, T f10, T f11)
{
  T fx0 = Linear(x, x0, x1, f00, f10);
  T fx1 = Linear(x, x0, x1, f01, f11);

  T fxy = Linear(y, y0, y1, fx0, fx1);

  return fxy;
}

template <class T>
T Trilinear(
  coord3<T> topLeft,
  coord3<T> botRight,
  coord3<T> coord,
  std::array<T, 4> f0,
  std::array<T, 4> f1)
{
  T fz0 = Bilinear(coord.x, topLeft.x, botRight.x,
    coord.y, topLeft.y, botRight.y, f0[0], f0[1], f0[2], f0[3]);
  T fz1 = Bilinear(coord.x, topLeft.x, botRight.x,
    coord.y, topLeft.y, botRight.y, f1[0], f1[1], f1[2], f1[3]);

  T fxyz = Linear(coord.z, topLeft.z, botRight.z, fz0, fz1);

  return fxyz;
}
