#include "Image.h"
#include "Vector.h"
#include <string.h>
#include <math.h>
#include <assert.h>


//  template Image<int> operator+< int >(const Image< int > &img1, const Image< int > &img2);
//  template Image<int> operator-< int >(const Image< int > &img1, const Image< int > &img2);
//  template Image<int> operator*< int >(const Image< int > &img1, const Image< int > &img2);

template< class T > Image< T >::Image(char const *name)
{
  width = height = 0;
  pixels = NULL;
}

template< class T > Image< T >::Image(int w, int h, char const *name)
{
  pixels = (T **)calloc(h, sizeof(T *));
  assert(pixels);
  pixels[0] = (T *)calloc(w * h, sizeof(T));
  assert(pixels[0]);

  for (int i = 1; i < h; i++)
    pixels[i] = pixels[i - 1] + w;

  width = w;
  height = h;
}

template< class T > Image< T >::Image(const Image<T> &img)
{
  width  = img.width;
  height = img.height;
  pixels = NULL;
  if (img.width * img.height != 0)
    setPixels(img.width, img.height, img.pixels[0]);
}

template< class T > void Image< T >::destroyImage()
{
  if (pixels != NULL)
  {
    free(pixels[0]);
    free(pixels);
    pixels = NULL;
    width = height = 0;
  }
}

template< class T > Image< T >::~Image()
{
  destroyImage();
}

template< class T > void Image< T >::makeImage(int w, int h)
{
  destroyImage();

  pixels = (T **)calloc(h, sizeof(T*));
  assert(pixels);
  pixels[0] = (T*)calloc(w * h, sizeof(T));
  assert(pixels[0]);


  for (int i = 1; i < h; i++)
    pixels[i] = pixels[i - 1] + w;

  width = w;
  height = h;
}

template< class T > void Image< T >::setPixels(int w, int h, T* data)
{
  makeImage(w, h);

  assert(data);
  memcpy(pixels[0], data, getSize()*sizeof(T));

}


template< class T > Image< T > &Image< T >::operator=(const Image< T > &img)
{
  if (this != &img)
  {
    width = img.width;
    height = img.height;
    if (img.width * img.height != 0)
      setPixels(img.width, img.height, img.pixels[0]);
    else
      pixels = NULL;
  }
  return *this;
}

template< class T > int Image< T >::operator==(const Image< T > &img)
{
  if (width == img.width && height == img.height)
    return (!memcmp(pixels[0], img.pixels[0], getSize() * sizeof(T)));
  else
    return (width == img.width && height == img.height);
}

template< class T > int Image< T >::operator!=(const Image< T > &img)
{
  if (width == img.width && height == img.height)
    return (memcmp(pixels[0], img.pixels[0], getSize() * sizeof(T)));
  else
    return (width != img.width && height != img.height);
}

template< class T > Image< T > &Image< T >::operator+=(const T val)
{
  for (int i = 0; i < getSize(); i++)
    pixels[0][i] += val;
  return (*this);
}

template< class T > Image< T > &Image< T >::operator-=(const T val)
{
  for (int i = 0; i < getSize(); i++)
    pixels[0][i] -= val;
  return (*this);
}

template< class T > Image< T > &Image< T >::operator+=(const Image< T > &img)
{
  if (width != img.width || height != img.height)
  {
    printf("The two images have different sizes");
    throw;
  }
  else
  {
    for (int i = 0; i < getSize(); i++)
      pixels[0][i] += img.pixels[0][i];
    return *this;
  }
}

template< class T > Image< T > &Image< T >::operator-=(const Image< T > &img)
{
  if (width != img.width || height != img.height)
  {
    printf("The two images have different sizes");
    throw;
  }
  else
  {
    for (int i = 0; i < getSize(); i++)
      pixels[0][i] -= img.pixels[0][i];
    return *this;
  }
}

template< class T > void Image< T >::clearImage()
{
  memset(pixels[0], 0, sizeof(T)*getSize());
}

template< class T > void Image< T >::clearImage(const T val)
{
  for (int i = 0, sz = getSize(); i < sz; ++i)
    pixels[0][i] = val;
}


template< class T > void Image< T >::makeEvenSized(void)
{
  Image< T > temp = *this;
  if ((width % 2 == 1) || (height % 2 == 1))
  {
    makeImage(temp.width + temp.width % 2, temp.height + temp.height % 2);
    for (int i = 0; i < temp.height; i++)
      for (int j = 0; j < temp.width; j++)
        pixels[i][j] = temp[i][j];
    for (int i = 0; i < temp.height; i++)
      pixels[i][width - 1] = temp[i][temp.width - 1];
    for (int j = 0; j < temp.width; j++)
      pixels[height - 1][j] = temp[temp.height - 1][j];
    pixels[height - 1][width - 1] = pixels[height - 1][width - 2];
  }
}



/**************************************************************************
 *  line_fast                                                             *
 *    draws a line using Bresenham's line-drawing algorithm, which uses   *
 *    no multiplication or division.                                      *
 **************************************************************************/

template<class T>
void Image<T>::drawLine(int x1, int y1, int x2, int y2, T color)
{
  int i, dx, dy, sdx, sdy, dxabs, dyabs, x, y, px, py;

  dx = x2 - x1;  /* the horizontal distance of the line */
  dy = y2 - y1;  /* the vertical distance of the line */
  dxabs = abs(dx);
  dyabs = abs(dy);
  sdx = ((dx < 0) ? -1 : ((dx > 0) ? 1 : 0));
  sdy = ((dy < 0) ? -1 : ((dy > 0) ? 1 : 0));
  x = dyabs >> 1;
  y = dxabs >> 1;
  px = x1;
  py = y1;

  pixels[py][px] = color;

  if (dxabs >= dyabs) /* the line is more horizontal than vertical */
  {
    for (i = 0; i < dxabs; i++)
    {
      y += dyabs;
      if (y >= dxabs)
      {
        y -= dxabs;
        py += sdy;
      }
      px += sdx;
      pixels[py][px] = color;
    }
  }
  else /* the line is more vertical than horizontal */
  {
    for (i = 0; i < dyabs; i++)
    {
      x += dxabs;
      if (x >= dyabs)
      {
        x -= dyabs;
        px += sdx;
      }
      py += sdy;
      pixels[py][px] = color;
    }
  }
}


template class Image< char >;
template class Image< byte >;
template class Image< short >;
template class Image< int >;
template class Image< float >;
template class Image< double >;
template class Image< Vector >;

