#include "ImportanceVolume.h"


ImportanceVolume::ImportanceVolume(Volume<float>& imp, int size):
  importance(imp),
  size(size),
  sortedImportancePoints(createImportanceIndex(imp, size))
{
  imp.getMinMax(minImportance, maxImportance);
}

float ImportanceVolume::GetEqualizedImportance(float normThreshold)
{
  float index = normThreshold * (sortedImportancePoints.size() - 1);
  return sortedImportancePoints[static_cast<size_t>(index)];
}

float ImportanceVolume::GetLargestDifferenceThreshold()
{
  return largestDifferenceThreshold;
}

float ImportanceVolume::GetMaxImportance()
{
  return maxImportance;
}

float ImportanceVolume::GetMinImportance()
{
  return minImportance;
}

std::vector<float> ImportanceVolume::createImportanceIndex(Volume<float>& imp, int size)
{
  std::vector<float> sortedImportancePoints;
  std::vector<float> allImportancePoints = getSortedImportancePoints();

  largestDifferenceThreshold = findLargestDifferenceThreshold(allImportancePoints);

  sortedImportancePoints.reserve(size + 1);
  float stepSize = 1.0f / size;
  for (float i = 0.0f; i <= 1.00f; i += stepSize)
  {
    int index = static_cast<size_t>(i * (allImportancePoints.size() - 1));
    sortedImportancePoints.push_back(allImportancePoints[index] + std::numeric_limits<float>::epsilon());
  }

  return sortedImportancePoints;
}

std::vector<float> ImportanceVolume::getSortedImportancePoints()
{
  std::vector<float> allImportancePoints;
  importance.toVector(allImportancePoints);
  auto newEnd = std::remove_if(allImportancePoints.begin(),
                               allImportancePoints.end(), [](float a) {return a == 0.0f; });
  allImportancePoints.erase(newEnd, allImportancePoints.end());
  std::sort(allImportancePoints.begin(), allImportancePoints.end());

  return allImportancePoints;
}

float ImportanceVolume::findLargestDifferenceThreshold(std::vector<float> allImportancePoints)
{
  float largestDiff = 0.0f;
  float bestThreshold = 0.0f;

  for (size_t i = 1; i < allImportancePoints.size(); i++)
  {
    float diff = allImportancePoints[i] - allImportancePoints[i - 1];
    if (diff > largestDiff)
    {
      largestDiff = diff;
      bestThreshold = allImportancePoints[i - 1];
    }
  }

  return bestThreshold;
}


Volume<float>& ImportanceVolume::GetInnerVolume()
{
  return importance;
}
