#include "cuts/CutController.h"

namespace cuts
{

void CutController::compute()
{
  up_cutSet->compute(*up_cutCreator);
}

void CutController::transform()
{
  up_cutSet = up_cutSet->transform(*up_transform);
}

CutSet &CutController::getCutSet()
{
  return *up_cutSet;
}

void CutController::setCutSet( std::unique_ptr<CutSet> value)
{
  up_cutSet = std::move(value);
}

CutCreator &CutController::getCutCreator()
{
  return *up_cutCreator;
}

void CutController::setCutCreator( std::unique_ptr<CutCreator> value)
{
  up_cutCreator = std::move(value);
}

Transform &CutController::getTransform()
{
  return *up_transform;
}

void CutController::setTransform( std::unique_ptr<Transform> value)
{
  up_transform = std::move(value);
}

}
