#include "cuts/EdtFitCutCreator.h"
#include "cuts/Cut.h"
#include "collapseSkel3d.h"

#include <array>

#include <vector>
#include <Eigen/Core>
#include <Eigen/SVD>

namespace cuts
{

surface::PlaneTrace::Plane EdtFitCutCreator::makeCutPlane(size_t skelpoint_idx)
{
  //use the tripplet as it forms more or less a max triangle in the edt
  const FeaturePoints::FeatureTriple &feature_triple = r_fp.featurePoints[skelpoint_idx];


  std::vector<std::array<double, 3>> skelPoints;
  auto p3d_p1 = r_surfaceGraph.boundary->at(feature_triple.first);
  skelPoints.push_back({p3d_p1.x, p3d_p1.y, p3d_p1.z});
  auto p3d_p2 = r_surfaceGraph.boundary->at(feature_triple.second);
  skelPoints.push_back({p3d_p2.x, p3d_p2.y, p3d_p2.z});
  auto p3d_p3 = r_surfaceGraph.boundary->at(feature_triple.third);
  skelPoints.push_back({p3d_p3.x, p3d_p3.y, p3d_p3.z});

  //map matrix to estimate direction
  Eigen::Map<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic, Eigen::RowMajor>>
    pointsMat(&skelPoints[0][0], skelPoints.size(), 3);

  Eigen::MatrixXd centered = pointsMat.rowwise() - pointsMat.colwise().mean();
  //use SVD to get normal direction
  Eigen::JacobiSVD<Eigen::MatrixXd> svd(centered, Eigen::ComputeThinV);
  Eigen::Vector3d normal(svd.matrixV().col(2));

  const FeaturePoints::FeatureTriple &feature_pair = r_fp.featurePoints[skelpoint_idx];
  Point3d p3d_origin = r_surfaceGraph.boundary->at(feature_pair.first);
  Eigen::Vector3d origin(p3d_origin.x, p3d_origin.y, p3d_origin.z);

  surface::PlaneTrace::Plane plane(normal, origin);
  plane.normalize();
  return plane;
}

}
