#include "cuts/PerpToSkelCutCreator.h"
#include "cuts/Cut.h"
#include "collapseSkel3d.h"

#include <array>

#include <vector>
#include <Eigen/Core>
#include <Eigen/SVD>

namespace cuts
{

namespace
{
//TODO: refactor this stuff to some functions somewhere in skelmodel or something
enum class ImportanceFieldDirection
{
  up,
  down
};

//get the next skeleton point wrt the importance field
template<ImportanceFieldDirection direction>
Point3d getNextSkelPoint(
    const Point3d &p_origin,
    const Volume<float> &importanceVolume)
{
  float imp_origin = importanceVolume(p_origin.x, p_origin.y, p_origin.z);
  float max_imp = -1.0f;
  Point3d p_maxNeighbor = p_origin;
  for (size_t i = p_origin.x - 1; i != (size_t)p_origin.x + 2; ++i)
    for (size_t j = p_origin.y - 1; j != (size_t)p_origin.y + 2; ++j)
      for (size_t k = p_origin.z - 1; k != (size_t)p_origin.z + 2; ++k)
      {
        if (k == j && j == i) continue;
        float imp_neighbor = importanceVolume(i,j,k);
        if (direction == ImportanceFieldDirection::up)
        {
          if (imp_neighbor < imp_origin) continue;
        }
        else
        {
          if (imp_neighbor > imp_origin) continue;
        }
        if (imp_neighbor > max_imp)
        {
          max_imp = imp_neighbor;
          p_maxNeighbor = Point3d(i,j,k);
        }
      }
  return p_maxNeighbor;
}

}

surface::PlaneTrace::Plane PerpToSkelCutCreator::makeCutPlane(size_t skelpoint_idx)
{
  //estimate direction of skeleton by moving 'up' in the importance field
  //as we're moving up that point must also be part of the skeleton.
  //do the same thing while moving `down`, using the 'largest skeleton point
  //less important than the current one;

  std::vector<std::array<double, 3>> skelPoints;
  Point3d p_origin = r_fp.fullSkeleton[skelpoint_idx];
  skelPoints.push_back({p_origin.x, p_origin.y, p_origin.z});

  const size_t max_steps = 4;


  //go up
  {
    Point3d p_current = p_origin;
    for (size_t step = 0; step != max_steps; ++step)
    {
      Point3d p_maxNeighbor = getNextSkelPoint<ImportanceFieldDirection::up>(p_current, r_skel.getImportance());
      //no new max found:
      if (p_maxNeighbor == p_current) break;
      //add new point
      p_current = p_maxNeighbor;
      skelPoints.push_back({p_current.x, p_current.y, p_current.z});
    }
  }

  //go down
  {
    Point3d p_current = p_origin;
    for (size_t step = 0; step != max_steps; ++step)
    {
      Point3d p_maxNeighbor = getNextSkelPoint<ImportanceFieldDirection::down>(p_current, r_skel.getImportance());
      //no new max found:
      if (p_maxNeighbor == p_current) break;
      //add new point
      p_current = p_maxNeighbor;
      skelPoints.push_back({p_current.x, p_current.y, p_current.z});
    }
  }
  //map matrix to estimate direction
  Eigen::Map<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic, Eigen::RowMajor>>
    pointsMat(&skelPoints[0][0], skelPoints.size(), 3);

  Eigen::MatrixXd centered = pointsMat.rowwise() - pointsMat.colwise().mean();
  //use SVD to get principal direction
  Eigen::JacobiSVD<Eigen::MatrixXd> svd(centered, Eigen::ComputeThinV);
  Eigen::Vector3d normal(svd.matrixV().col(0));

  const FeaturePoints::FeatureTriple &feature_pair = r_fp.featurePoints[skelpoint_idx];
  Point3d p3d_origin = r_surfaceGraph.boundary->at(feature_pair.first);
  Eigen::Vector3d origin(p3d_origin.x, p3d_origin.y, p3d_origin.z);

  surface::PlaneTrace::Plane plane(normal, origin);
  plane.normalize();
  return plane;
}

}
