#include "cuts/PlaneTraceCutCreator.h"
#include "cuts/Cut.h"

#include "surface/PlaneTrace.h"
#include "surface/Graph.h"
#include "surface/AStar.h"

#include <iostream>

namespace cuts
{

PlaneTraceCutCreator::PlaneTraceCutCreator(
  const FeaturePoints &fp,
  const surface::Graph &sufaceGraph,
  const collapseSkel3d &skel,
  const std::vector<Point3d> &surfaceNormals,
  const size_t bandDeviation)
  :
  CutCreator(fp, sufaceGraph, skel),
  r_normals(surfaceNormals),
  d_bandDeviation(bandDeviation)
{
  std::cout << "surface size:" << r_surfaceGraph.size() << ", "
            << "normal size:" << r_normals.size() << '\n';
}

surface::PlaneTrace::Plane PlaneTraceCutCreator::makeCutPlane(size_t skelpoint_idx)
{
  const FeaturePoints::FeatureTriple &feature_pair = r_fp.featurePoints[skelpoint_idx];

  //construct the cut plane
  Point3d p3d_p1 = r_fp.fullSkeleton[skelpoint_idx];
  Eigen::Vector3d p1(p3d_p1.x, p3d_p1.y, p3d_p1.z); //skelpoint pos

  Point3d p3d_p2 = r_surfaceGraph.boundary->at(feature_pair.first);
  Eigen::Vector3d p2(p3d_p2.x, p3d_p2.y, p3d_p2.z); //fp1 pos

  Point3d p3d_p3 = r_surfaceGraph.boundary->at(feature_pair.second);
  Eigen::Vector3d p3(p3d_p3.x, p3d_p3.y, p3d_p3.z); //fp2 pos

  //std::cout << p1 << '\n' <<  p2 << '\n' << p3 << "\n\n";
  //std::cout << (p2-p1) << '\n' << (p3-p1) << '\n' << (p2-p1).cross(p3-p1) << '\n';

  Eigen::Vector3d normal = (p2 - p1).cross(p3 - p1);
  //std::cout << normal.norm() << '\n';
  //keep selecting the p3 = midpoint(p2,p3), until shit works
  for (size_t it = 0; it != 4; ++it)
  {
    if (normal.norm() > 1e-12) //arbitrarily small
      break;
    std::cout << "colinear vectors!\n";

    //due to the thinning method both fp can end up having the same raster coordinate
    if (p2 == p3)
    {
      std::cout << "p2 == p3\n";
      normal = Eigen::Vector3d(p2[1], -p2[0], 0.0);
      break;
    }


    //replace p3 by midpoint of path from p2 to p3
    auto up_path = surface::AStar(r_surfaceGraph).shortestPath(
        feature_pair.first, feature_pair.second);
    p3d_p3 = r_surfaceGraph.boundary->at(up_path->midPoint()->id);
    Eigen::Vector3d new_p3 = Eigen::Vector3d(p3d_p3.x, p3d_p3.y, p3d_p3.z);

    p3 = new_p3;
    normal = (p2 - p1).cross(p3 - p1);
  }
  surface::PlaneTrace::Plane plane(normal, p1);
  plane.normalize();
  return plane;
}

std::unique_ptr<Cut> PlaneTraceCutCreator::
operator()(size_t skelpoint_idx)
{
  std::unique_ptr<Cut> up_cut(new Cut);
  up_cut->d_skelpoint_idx = skelpoint_idx;

  surface::PlaneTrace planeTrace(r_surfaceGraph, r_normals);

  const FeaturePoints::FeatureTriple &feature_pair = r_fp.featurePoints[skelpoint_idx];
  int seed_boundary_index = feature_pair.first;

  //construct the cut plane
  auto cutPlane = makeCutPlane(skelpoint_idx);
  double bandDeviation = d_bandDeviation;
  //std::cout << "computing planetracecut for " << skelpoint_idx << "\n";
  while (bandDeviation >= .5)
  {
    up_cut->up_path = planeTrace.trace(seed_boundary_index, cutPlane, bandDeviation);
    if (up_cut->up_path) break;
    //std::cout << "halving band with for " << skelpoint_idx << "\n";
    bandDeviation /= 2;
  }
  return std::move(up_cut);
}

}
