#include "coord3.h"
#include "Volume.h"
#include "filters.h"
#include <deque>
#include <set>
#include <map>
#include <iostream>
#include <algorithm>
#include <queue>
#include <math.h>


using namespace std;



typedef deque<coord3s>   Path;
typedef set<coord3s>     Set;



Set findNbs(const coord3s &s, const Path &p, const Volume<float> &vol, float thr)
{
  const coord3s &h = p[0];

  Set ret;
  for (int i = h.x - 1; i <= h.x + 1; ++i)
    for (int j = h.y - 1; j <= h.y + 1; ++j)
      for (int k = h.z - 1; k <= h.z + 1; ++k)
      {
        coord3s c(i, j, k);
        if (i < s.x - 1 || i > s.x + 1 || j < s.y - 1 || j > s.y + 1 || k < s.z - 1 ||
            k > s.z + 1) continue;   //next voxel must be in 3x3x3 nbhood of s
        if (c == s) continue;                                 //next voxel must not be s
        if (c == h) continue;
        if (vol(c) < thr)
          continue;                             //next voxel must be foreground

        if (p.size() >
            1)                                   //next voxel must not be a 6-nb of pred(h)
        {
          const coord3s &a = p[1];
          int dx = abs(a.x - i), dy = abs(a.y - j), dz = abs(a.z - k);
          if (dx < 2 && dy < 2 && dz < 2) continue;
        }

        Path::const_reverse_iterator it = std::find(p.rbegin(), p.rend(),
                                          c);         //next voxel must not be in p (except the end of p, in which case we have a loop)
        if (it != p.rend())
        {
          if (it != p.rbegin()) continue;
          else if (p.size() <= 3) continue;
        }


        ret.insert(c);
      }
  return ret;
}


bool findLoop(const coord3s &s, const Path &p, const Volume<float> &vol,
              float thr)
{
  Set C = findNbs(s, p, vol,
                  thr);                //find all possible extensions of path further on

  for (Set::const_iterator it = C.begin(); it != C.end();
       ++it)   //try searching for loop extending path:
  {
    const coord3s &nh = *it;
    if (p.size() >= 4 && nh == p[p.size() - 1])
      return true;
  }


  for (Set::const_iterator it = C.begin(); it != C.end();
       ++it)   //try searching for loop extending path:
  {
    const coord3s &nh = *it;
    Path q = p;
    q.push_front(nh);
    if (findLoop(s, q, vol, thr)) return true;
  }
  return false;
}



bool isBoundary(const coord3s &p, const Volume<float> &vol, float thr)
{
  for (int i = p.x - 1; i <= p.x + 1; ++i)
    for (int j = p.y - 1; j <= p.y + 1; ++j)
      for (int k = p.z - 1; k <= p.z + 1; ++k)
      {
        coord3s c(i, j, k);
        if (c == p) continue;
        if (vol(c) < thr) continue;
        Path path;
        path.push_front(c);
        bool ret = findLoop(p, path, vol, thr);
        if (ret) return false;          //loop found: interior

      }

  return true;                //no loop found: boundary
}




int visit(const set<coord3s> &seeds, const Volume<byte> &vol, byte foreground,
          coord3s &closest)
{
  map<coord3s, int>   closed;
  deque<coord3s> q;

  for (set<coord3s>::const_iterator it = seeds.begin(); it != seeds.end(); ++it)
  {
    coord3s p = *it;
    closed.insert(make_pair(p, 0));

    for (int i = p.x - 1; i <= p.x + 1; ++i)
      for (int j = p.y - 1; j <= p.y + 1; ++j)
        for (int k = p.z - 1; k <= p.z + 1; ++k)
        {
          coord3s n(i, j, k);
          if (std::find(q.begin(), q.end(), n) == q.end())
            q.push_back(n);
        }
  }


  while (!q.empty())
  {
    coord3s p = q.front();
    q.pop_front();

    int dmin = 1.0e+7;
    for (int i = p.x - 1; i <= p.x + 1; ++i)
      for (int j = p.y - 1; j <= p.y + 1; ++j)
        for (int k = p.z - 1; k <= p.z + 1; ++k)
        {
          coord3s n(i, j, k);
          map<coord3s, int>::const_iterator cl = closed.find(n);
          if (cl == closed.end()) continue;
          dmin = std::min(dmin, (p.x - i) * (p.x - i) + (p.y - j) * (p.y - j) +
                          (p.z - k) * (p.z - k) + cl->second);
        }

    if (vol(p) == foreground)
    {
      closest = p;
      return dmin;
    }

    closed.insert(make_pair(p, dmin));

    for (int i = p.x - 1; i <= p.x + 1; ++i)
      for (int j = p.y - 1; j <= p.y + 1; ++j)
        for (int k = p.z - 1; k <= p.z + 1; ++k)
        {
          coord3s n(i, j, k);
          if (closed.find(n) != closed.end()) continue;
          if (std::find(q.begin(), q.end(), n) != q.end()) continue;
          q.push_back(n);
        }
  }

  return -1;
}



void eraseCC(const coord3s &p, Volume<byte> &vol, byte background)
{
  queue<coord3s> q;
  set<coord3s> closed;
  byte foreground = vol(p);

  q.push(p);
  closed.insert(p);
  while (!q.empty())
  {
    coord3s p = q.front();
    q.pop();
    vol(p) = background;

    for (int i = p.x - 1; i <= p.x + 1; ++i)
      for (int j = p.y - 1; j <= p.y + 1; ++j)
        for (int k = p.z - 1; k <= p.z + 1; ++k)
        {
          coord3s n(i, j, k);
          if (n == p) continue;
          if (vol(n) != foreground) continue;
          if (closed.find(n) != closed.end()) continue;
          q.push(n);
          closed.insert(n);
        }
  }
}


set<coord3s> xx;


int sizeCC(const coord3s &p, const Volume<byte> &vol, int max_size)
{
  queue<coord3s> q;
  set<coord3s> closed;
  byte foreground = vol(p);

  int size = 0;
  q.push(p);
  closed.insert(p);
  while (!q.empty())
  {
    coord3s p = q.front();
    q.pop();
    ++size;
    if (max_size > 0 && size > max_size)
    {
      xx = closed;
      return size;
    }

    for (int i = p.x - 1; i <= p.x + 1; ++i)
      for (int j = p.y - 1; j <= p.y + 1; ++j)
        for (int k = p.z - 1; k <= p.z + 1; ++k)
        {
          coord3s n(i, j, k);
          if (n == p) continue;
          if (vol(n) != foreground) continue;
          if (closed.find(n) != closed.end()) continue;
          q.push(n);
          closed.insert(n);
        }
  }

  xx = closed;
  return size;
}

int closestCC(const coord3s &p, const Volume<byte> &vol, coord3s &closest)
{
  return visit(xx, vol, 255, closest);
}


//--------



bool isB(int i, int j, int k, const Volume<float> &v, float t)
{
  int c, J, I, K;

  c = 0;
  for (J = j - 1; J <= j + 1; ++J)
    for (K = k - 1; K <= k + 1; ++K)
      if ((J != j || K != k) && v(K, J, i) >= t) ++c;
  if (c == 1) return true;

  c = 0;
  for (J = j - 1; J <= j + 1; ++J)
    for (I = i - 1; I <= i + 1; ++I)
      if ((J != j || I != i) && v(k, J, I) >= t) ++c;
  if (c == 1) return true;

  c = 0;
  for (I = i - 1; I <= i + 1; ++I)
    for (K = k - 1; K <= k + 1; ++K)
      if ((I != i || K != k) && v(K, j, I) >= t) ++c;
  if (c == 1) return true;


  return false;
}




