#include "level_set.h"
#include <math.h>
#include <cassert>
#include <functional>
#include <algorithm>

//static int xc[]={-1,0,0,1};
//static int yc[]={0,-1,1,0};
static int xc[] = {1, -1, 0, 0, 0, 0};
static int yc[] = {0, 0, 1, -1, 0, 0};
static int zc[] = {0, 0, 0, 0, 1, -1};
static int nsize = sizeof(xc) / sizeof(int);

template< class T, class COMP >
real levelSet<T, COMP>::F(int x, int y, int z)
{
  float m = exp(0.2f * img[z][y][x]);
  //printf("%f ", m);

  return m;
}

template< class T, class COMP >
void levelSet<T, COMP>::Init(float thr)
{
  for (int z = 0; z < depth; z++)
    for (int y = 0; y < height; y++)
      for (int x = 0; x < width; x++)
      {
        if (img[z][y][x] > thr)
        {
          printf("bla\n");
          int pos = z * width * height + y * width + x;
          //status[pos].Time()=img[z][y][x];
          status[pos].Time() = 0;
          status[pos].Flag() = TRIAL;
          //map_insert(x, y, z, img[z][y][x]);
          map_insert(x, y, z, 0);
        }
        else if (img[z][y][x] < 1e-5f)
        {
          int pos = z * width * height + y * width + x;
          status[pos].Time() = 0;
          status[pos].Flag() = ACCEPTED;
        }
      }
}

template< class T, class COMP >
void levelSet<T, COMP>::Init(int x, int y, int z)
{
  int pos = z * width * height + y * width + x;

  status[pos].Time() = img[z][y][x];
  status[pos].Flag() = TRIAL;
  map_insert(x, y, z, img[z][y][x]);
}

template< class T, class COMP >
inline real levelSet<T, COMP>::eikonal(float x, float f, float T1, float T2,
                                       float T3, float T4, float T5, float T6)
{
  T1 = std::max(x - T1, 0.0f);
  T2 = std::min(T2 - x, 0.0f);
  T3 = std::max(x - T3, 0.0f);
  T4 = std::min(T4 - x, 0.0f);
  T5 = std::max(x - T5, 0.0f);
  T6 = std::min(T6 - x, 0.0f);

  return T1 * T1 + T2 * T2 + T3 * T3 + T4 * T4 + T5 * T5 + T6 * T6 - 1.0 /
         (f * f);
}

template< class T, class COMP >
real levelSet<T, COMP>::updateT(float tmin, int i, int j, int k)
{
  float t1, t2, t3, t4, t5, t6, f;
  float x1, x2, eq_x1, eq_x2;

  t1 = Tm(i - 1, j, k);
  t2 = Tm(i + 1, j, k);
  t3 = Tm(i, j - 1, k);
  t4 = Tm(i, j + 1, k);
  t5 = Tm(i, j, k - 1);
  t6 = Tm(i, j, k + 1);

  f = F(i, j, k);

  x1 = tmin;
  x2 = Tm(i, j, k);
  eq_x1 = eikonal(tmin, f, t1, t2, t3, t4, t5, t6);
  eq_x2 = eikonal(x2, f, t1, t2, t3, t4, t5, t6);

  if (eq_x1 * eq_x2 >= 0)
    return x2;

  while ((eq_x2 > EPS) || (eq_x2 < -EPS))
  {
    x1 = (tmin + x2) / 2;
    eq_x2 = eikonal(x1, f, t1, t2, t3, t4, t5, t6);

    if (eq_x1 * eq_x2 >= 0)
    {
      tmin = x1;
      eq_x1 = eq_x2;
    }
    else
    {
      x2 = x1;
    }
    if (((x2 - tmin) / x2 < EPS) && (x2 - tmin) / x2 > -EPS)
      break;
  }

  return x1;
}

template< class T, class COMP >
float levelSet< T, COMP >::fastMarching()
{
  real ctime = 0.0, ptime = 0.0;
  int x, y, z, nx, ny, nz, k;

  while (!map_empty())
  {
    std::pair<real, coord> top = map_pop();
    ctime = top.first;
    /*
    if(ptime-ctime>TIME_THR) {
      ctime=ptime;
      break;
    }
    */
    x = top.second[0];
    y = top.second[1];
    z = top.second[2];

    FL(x, y, z) = ACCEPTED;

    //if(img[z][y][x]<1e-7f) continue;

    for (k = 0; k < nsize; k++)
    {
      nx = x + xc[k];
      ny = y + yc[k];
      nz = z + zc[k];
      if (Volume<T>::range(nx - 1, ny - 1, nz - 1, width - 2, height - 2,
                           depth - 2) &&
          !COMP()(Tm(nx, ny, nz), ctime))
      {
        if (FL(nx, ny, nz) == TRIAL)
        {
          Tm(nx, ny, nz) = updateT(ctime, nx, ny, nz);
          map_update(nx, ny, nz, Tm(nx, ny, nz));
        }
        else if (FL(nx, ny, nz) == FARAWAY)
        {
          FL(nx, ny, nz) = TRIAL;
          Tm(nx, ny, nz) = updateT(ctime, nx, ny, nz);
          map_insert(nx, ny, nz, Tm(nx, ny, nz));
        }
      }
    }

    if (ctime < 0.990f * TIME_MAX)
      ptime = ctime;

    if (wf) wf();
    if (df) df();
  };

  for (int k = 0; k < depth; k++)
    for (int j = 0; j < height; j++)
      for (int i = 0; i < width; i++)
        if (FL(i, j, k) != ACCEPTED)
          //if(FL(i, j, k)==FARAWAY)
          Tm(i, j, k) = ptime;

  printf("time=%g\n", ptime);

  return ptime;
}

template<class T, class COMP>
void levelSet<T, COMP>::output(Volume<float> &img, float max_time)
{
  for (int k = 0; k < depth; k++)
    for (int i = 0; i < height; i++)
      for (int j = 0; j < width; j++)
      {
        if (img[k][i][j] > 0.0001f)
        {
          //printf("%f ", img[k][i][j]);
          float m =  1.0f - Tm(j, i, k) / max_time;
          /*
          if(m<=0.0f || m>=1.0f)
            printf("%f ", m);
          */
          img[k][i][j] = m / 1000.0f;
          //printf("%f ",  Tm(j, i, k) );
        }
        else img[k][i][j] = 0.0f;
      }
}

//template class levelSet<int, greater<float> >;
//template class levelSet<int, less<float> >;

template class levelSet<float, std::greater<float> >;
template class levelSet<float, std::less<float> >;
