#include "utils.h"
#include "Point3d.h"
#include <math.h>
#include <algorithm>
#include <Volume.h>

using namespace std;


void float2rgb(float value, float *col) //simple color-coding routine
{
  static const float dx = 0.8f;

  if (value < 0.0f) value = 0.0f;
  if (value > 1.0f) value = 1.0f;

  value = (6.0f - 2.0f * dx) * value + dx;
  col[0] = std::max(0.0f, (3.0f - fabsf(value - 4.0f) - fabsf(
                             value - 5.0f)) / 2.0f);
  col[1] = std::max(0.0f, (4.0f - fabsf(value - 2.0f) - fabsf(
                             value - 4.0f)) / 2.0f);
  col[2] = std::max(0.0f, (3.0f - fabsf(value - 1.0f) - fabsf(
                             value - 2.0f)) / 2.0f);
}

std::vector<Point3d> createThinSet(const Volume<byte>& thinImage)
{
  std::vector<Point3d> points;

  for (int i = 1; i < thinImage.getDepth() - 1; i++)
    for (int j = 1; j < thinImage.getHeight() - 1; j++)
      for (int k = 1; k < thinImage.getWidth() - 1; k++)
      {
        coord3s c(k, j, i);
        byte tval = thinImage(c);    //select all nonzero thin-volume voxels on the thin-volume surface
        if (tval)                     //(that is, foreground ones not surrounded by ONLY foreground voxels)
        {
          //copy them with their values from the thin-volume, normalized to [0..1]
          bool draw = false;
          for (int m = -1; m <= 1; m++)
            for (int n = -1; n <= 1; n++)
              for (int p = -1; p <= 1; p++)
                if (!thinImage(k + p, j + n, i + m) != 0)
                {
                  draw = true;
                  goto BREAK;
                }

        BREAK:
          if (draw)
          {
            points.emplace_back(k, j, i, tval / 255.0f);
          }
        }
      }

  return points;
}

float AreaTriangleSquared(const Point3d& A, const Point3d& B, const Point3d& C)
{
  return (A - C).cross(B - C).norm2();
}

Point3d InCenterTriangle(const Point3d& A, const Point3d& B, const Point3d& C)
{
  float a = (B - C).norm();
  float b = (C - A).norm();
  float c = (A - B).norm();

  float per = a + b + c;
  return A * (a / per) + B * (b / per) + C * (c / per);
}

Point3d InCenterTriangleOrtho(const Point3d& A, const Point3d& B, const Point3d& C)
{
  float a = (B - C).norm();
  float b = (C - A).norm();
  float c = (A - B).norm();

  float per = a + b + c;
  return (B + C) * (0.5f * a / per) + 
    (C + A) * (0.5f * b / per) + 
    (A + B) * (0.5f * c / per);
}

