#include <FeaturePoints.h>
#include <collapseSkel3d.h>
#include <memory>
#include <iostream>
#include <tuple>
#include <vector>
#include <boost/filesystem.hpp>

#include <iostream>
#include <fstream>
#include <sstream>

#include <SkeletonModel.h>
#include <surface/Graph.h>
#include <NoiseCreator.h>
#include <TestHelpers.h>
#include <SkeletonReconstructor.h>
#include "Stopwatch.h"

using namespace std;





bool TestDerivativeThreshold(std::string filename, bool estimateGoedesic)
{
  Volume<byte> data;
  boost::filesystem::path path(filename);

  if (!data.readVTKField(filename.c_str(), 10))
  {
    std::cerr << "Loading " << filename << " failed" << std::endl;
    return false;
  }
  Volume<byte> original = data;
  Volume<byte> orgSkeleton = ComputeSkeleton(data, false);

  collapseSkel3d skel(false, true);
  int borderVoxels;

  std::cout << "Computing Skeleton...." << std::endl;
  skel.init(data, 0, borderVoxels, false);
  std::shared_ptr<SkeletonModel> inputModel(new SkeletonModel(skel, 0.0f));
  surface::Graph graph;
  graph.construct(inputModel->GetThinPoints());

  // add noise, then reset skeleton
  NoiseCreator noiseCreator(data, graph, inputModel);
  noiseCreator.GeneratePoints(0.020f, NoisePickType::Convex, NoiseShape::Ball, 3.0f, 2);

  float noiseDiff = volumeDiff(original, data);

  // reprocess input model and graph after adding noise.
  graph.reset();
  inputModel->Update(skel, 0.3e-5f);
  graph.construct(inputModel->GetThinPoints());

  skel.reset();
  skel.init(data, 0, borderVoxels, false);

  Volume<float> newImportance = ComputeEstimatedEuclidean(skel.getEDT(), 2.0 * sqrt(2));

  skel.setImportance(newImportance);

  skel.set_ready(true);
  skel.getThinImage().clearVolume();

  std::shared_ptr<SkeletonModel> skeletonModel(new SkeletonModel(skel, 0.0f));


  FeaturePoints featurePoints(inputModel->GetThinPoints());
  featurePoints.construct(skeletonModel->GetSkelPoints(), skel.getV(), skel.getImportance(), skel.getEDT());
  SaliencyMetricEngine saliencyEngine = constructSaliencyEngine(skel, featurePoints);

  Volume<byte> reconstructedNoisy = Reconstruct(skeletonModel->GetSkelPoints(), skel.getEDT(),
    ReconstructionSmoothingType::None, 3);


  int totalUniquePoints = getUniqueForegroundPoints(original, reconstructedNoisy);
  int totalOriginalPoints = getForegroundPoints(original);

  int totalSkelPoints = getUniqueForegroundPoints(skel.getImportance(), orgSkeleton);
  int totalSkeletonPoints = getForegroundPoints(skel.getImportance());
  int totalOrgSkeletonPoints = getForegroundPoints(orgSkeleton);

  std::cout << "Calculating saliency Metric" << std::endl;
  Volume<float> geoImportance = saliencyEngine.ComputeGeodesicRaw(graph, estimateGoedesic);
  Volume<float>& importanceVol = geoImportance;
  skel.setImportance(geoImportance);


  ofstream logfile("threshold_vary_der_error_realgeo.csv", ios::out | ios::app);


  {
    VelocityMethod method = VelocityMethod::Feature;

    std::cout << "Method " << GetMethodName(method) << std::endl << std::endl;

    Volume<Vector> velocity = VelocityForMethod(method, skel, saliencyEngine, graph, importanceVol);
    for (float y = 0.0f; y <= 5.0f; y += 0.025f)
    {
      float x = 150.0f;
      Volume<float> saliency;
      if (method == VelocityMethod::GradientImportanceDirect)
        saliency = saliencyEngine.ComputeDerivativeGradient(velocity, graph);
      else
        saliency = saliencyEngine.ComputeDerivativeDirect(velocity, graph, y);


      Volume<byte> processedSkeleton = toByteVolume(saliency, x);

      skeletonModel->Update(skel, x, saliency, true);
      Volume<byte> reconstructed = Reconstruct(skeletonModel->GetSkelPoints(), skel.getEDT(),
        ReconstructionSmoothingType::None, 3, &saliency, x, &graph, &featurePoints);

      float letError = (float)volumeLeftDiff(reconstructed, original) / totalUniquePoints;
      float rightError = (float)volumeLeftDiff(original, reconstructed) / totalOriginalPoints;
      float allError = (float)volumeDiff(original, reconstructed) / totalUniquePoints;

      std::cout << "saliency: " << y << ", error: " << allError << std::endl;
      logfile << "\"" << filename << "\", " << "\"" << GetMethodName(method) << "\"" << ", " << y
        << ", " << letError << ", " << rightError << ", " << allError << std::endl;


      if (y > 1.79f && y < 1.81f)
      {
        std::string outRecFilename = path.stem().string() + "_" + GetMethodName(method) + ".vtk";
        std::string outSkelFilename = "Skel_" + path.stem().string() + "_" + GetMethodName(method) + ".vtk";
        std::string outSalFilename = "Sal_" + path.stem().string() + "_" + GetMethodName(method) + ".vtk";

        skeletonModel->Update(skel, x, saliency, true);
        ExportReconstruction(outRecFilename, skel, skeletonModel, saliency, x);
        processedSkeleton.exportVTKField(outSkelFilename.c_str());
        saliency.exportVTKField(outSalFilename.c_str());
      }
    }

  }
}



//int main(int argc, char *argv[])
//{
//  std::string filename;
//  bool useEstimate = false;
//
//  if (argc == 1)
//  {
//    std::cout << "Filename required as first argument." << std::endl;
//    return -1;
//  }
//
//  filename = argv[1];
//
//  return TestDerivativeThreshold(filename, useEstimate);
//}
