#include <FeaturePoints.h>
#include <collapseSkel3d.h>
#include <memory>
#include <iostream>
#include <tuple>
#include <vector>
#include <boost/filesystem.hpp>

#include <iostream>
#include <fstream>
#include <sstream>

#include <SkeletonModel.h>
#include <surface/Graph.h>
#include <NoiseCreator.h>
#include <TestHelpers.h>
#include <SkeletonReconstructor.h>
#include "Stopwatch.h"

using namespace std;





int TestGeo(std::string filename)
{
  Volume<byte> data;
  boost::filesystem::path path(filename);

  if (!data.readVTKField(filename.c_str(), 10))
  {
    std::cerr << "Loading " << filename << " failed" << std::endl;
    return false;
  }
  FilterLargestComponent(data, (byte)0);

  Volume<byte> original = data;

  collapseSkel3d skel(false, true);
  int borderVoxels;

  std::cout << "Computing Skeleton...." << std::endl;
  skel.init(original, 0, borderVoxels, false);
  Volume<byte> oldThin = skel.getThinImage();

  std::shared_ptr<SkeletonModel> inputModel(new SkeletonModel(skel, 0.0f));
  surface::Graph graph;
  graph.construct(inputModel->GetThinPoints());
  Volume<float> newImportance = ComputeEstimatedEuclidean(skel.getEDT(), 2.0 * sqrt(2));

  skel.setImportance(newImportance);

  skel.set_ready(true);
  skel.getThinImage().clearVolume();


  std::shared_ptr<SkeletonModel> skeletonModel(new SkeletonModel(skel, 0.0f));

  FeaturePoints featurePoints(inputModel->GetThinPoints());
  featurePoints.construct(skeletonModel->GetSkelPoints(), skel.getV(), skel.getImportance(), skel.getEDT());
  SaliencyMetricEngine saliencyEngine = constructSaliencyEngine(skel, featurePoints);

  Volume<float> trueGeo = saliencyEngine.ComputeGeodesicRaw(graph, false);
  Volume<float> estGeo = saliencyEngine.ComputeGeodesicRaw(graph, true);

  ofstream logfile("geo_vs_estimate.csv", ios::out | ios::app);

  auto& skelPoints = skeletonModel->GetSkelPoints();
  for (size_t i = 0; i < skelPoints.size(); i++)
  {
    auto& p = skelPoints[i];
    float geo = trueGeo(p.x, p.y, p.z);
    float est = estGeo(p.x, p.y, p.z);

    logfile << "\"" << filename << "\", " << geo << ", " << est << std::endl;
  }

  return 0;

}

//int main(int argc, char *argv[])
//{
//  std::string filename;
//
//  if (argc == 1)
//  {
//    std::cout << "Filename required as first argument." << std::endl;
//    return -1;
//  }
//  filename = argv[1];
//
//  return TestGeo(filename);
//}
