#include "TestHelpers.h"
#include "VolumeHelpers.h"




void ExportReconstructionGen(ReconstructionSmoothingType method, std::string filename, collapseSkel3d& skel, std::shared_ptr<SkeletonModel> skeletonModel,
  Volume<float>& saliency, float imp,
  int kernel,
  bool constrainSearch ,
  surface::Graph* graph ,
  FeaturePoints* featurePoints )
{
  SkeletonReconstructor reconstructor(skeletonModel->GetSkelPoints(), skel.getEDT());
  Volume<byte> reconstruction = reconstructor.Reconstruct(method, kernel, &saliency, imp, graph, featurePoints, constrainSearch);
  reconstruction.exportVTKField(filename.c_str());

  size_t lastindex = filename.find_last_of(".");
  std::string rawname = filename.substr(0, lastindex);
  ExportVolumeToObj(rawname + ".obj", reconstruction);
}


void ExportReconstructionGenLog(std::ofstream& logstream, std::string input,
  Volume<byte>& original,
  ReconstructionSmoothingType method, 
  std::string filename, collapseSkel3d& skel, std::shared_ptr<SkeletonModel> skeletonModel,
  Volume<float>& saliency, float imp,
  int kernel,
  bool constrainSearch,
  surface::Graph* graph,
  FeaturePoints* featurePoints)
{
  SkeletonReconstructor reconstructor(skeletonModel->GetSkelPoints(), skel.getEDT());
  Volume<byte> reconstruction = reconstructor.Reconstruct(method, kernel, &saliency, imp, graph, featurePoints, constrainSearch);

  int totalPoints = getUniqueForegroundPoints(reconstruction, original);
  int totalReconstructionPoints = getForegroundPoints(reconstruction);
  int totalOriginalSkeletonPoints = getForegroundPoints(original);

  float leftError = (float)volumeLeftDiff(reconstruction, original) / totalReconstructionPoints;
  float rightError = (float)volumeLeftDiff(original, reconstruction) / totalOriginalSkeletonPoints;
  float allError = (float)volumeDiff(original, reconstruction) / totalPoints;

  logstream << input << ", " << filename << ", " << leftError << ", " << rightError << ", " << allError << std::endl;

  reconstruction.exportVTKField(filename.c_str());
  size_t lastindex = filename.find_last_of(".");
  std::string rawname = filename.substr(0, lastindex);
  ExportVolumeToObj(rawname + ".obj", reconstruction);
}


