#include <FeaturePoints.h>
#include <collapseSkel3d.h>
#include <memory>
#include <iostream>
#include <tuple>
#include <vector>

#include <iostream>
#include <fstream>
#include <sstream>

#include <SkeletonModel.h>
#include <surface/Graph.h>
#include <NoiseCreator.h>
#include <TestHelpers.h>

using namespace std;


bool TestReconstructionError()
{
  Volume<byte> data;
  
  if (!data.readAVSField("horse.fld", 2))
  {
    cerr << "Loading horse.fld failed" << endl;
    return false;
  }
  Volume<byte> original = data;

  ofstream logfile("result_horse_without_smoothing_and_noise.csv", ios::out);

  collapseSkel3d skel(false, true);
  int borderVoxels;

  cout << "Computing Skeleton...." << endl;
  skel.init(data, 0, borderVoxels, false);
  shared_ptr<SkeletonModel> inputModel(new SkeletonModel(skel, 0.0f));
  surface::Graph graph;
  graph.construct(inputModel->GetThinPoints());

  // add noise, then reset skeleton
  NoiseCreator noiseCreator(data, graph, inputModel);
  noiseCreator.GeneratePoints(0.020, NoisePickType::Convex, NoiseShape::Ball, 3.0f);

  skel.reset();
  skel.init(data, 0, borderVoxels, false);
  while (skel.collapse_iteration(1.0f));
  

  int totalPoints = getForegroundPoints(data);
  int totalSkeletonPoints = getForegroundPoints(skel.getImportance());

  std::vector<float> sortedImportancePoints = CreateImportanceIndex(skel.getImportance(), 10);

  for (float imp : sortedImportancePoints)
  {
    Volume<byte> reconstruction;
    SkeletonModel skeletonModel(skel, imp);
    reconstruction.makeVolume(data.getWidth(), data.getHeight(), data.getDepth());
    auto skelPoints = skeletonModel.GetSkelPoints();

    
    for (auto& p : skelPoints)
      reconstruction.addSphere(coord3s(p.x, p.y, p.z), 1, skel.getEDT()(p.x, p.y, p.z) - 0.01f);
      

    float error = static_cast<float>(volumeDiff(data, reconstruction)) / totalPoints;
    float volumeRatio = static_cast<float>(skelPoints.size()) / totalPoints;
    logfile << imp << ", " << error << ", " << volumeRatio << endl;
    cout << imp << ", " << error << ", " << volumeRatio << endl;
  }
  
}

